#include "mbed.h"
#include "LSM9DS1.h"
#include "Wireless.h"
//#include "USBKeyboard.h"
#define PI 3.14159
// Earth's magnetic field varies by location. Add or subtract
// a declination to get a more accurate heading. Calculate
// your's here:
// http://www.ngdc.noaa.gov/geomag-web/#declination
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);
DigitalIn pb1(p17);
Timeout walkingTimer;
WirelessModule wireless(p9, p10, FOOT_STEP);
bool isWalking = false;
// Calculate pitch, roll, and heading.
// Pitch/roll calculations taken from this app note:
// http://cache.freescale.com/files/sensors/doc/app_note/AN3461.pdf?fpsp=1
// Heading calculations taken from this app note:
// http://www51.honeywell.com/aero/common/documents/myaerospacecatalog-documents/Defense_Brochures-documents/Magnetic__Literature_Application_notes-documents/AN203_Compass_Heading_Using_Magnetometers.pdf


//Function that timeout calls when detected that person stops walking
void printStop()
{
    // pc.printf("stop\n\r");
    wireless.sendDirection(DIR_NONE);
    isWalking = false;
}

//Rotates raw heading so 0 degrees is forward direction
float correctHeading(float currHeading, float forward)
{
    float newHeading = currHeading - forward;
    if(newHeading < 0) newHeading = 360 + newHeading;
    return newHeading;
}

float printAttitude(float ax, float ay, float az, float mx, float my, float mz)
{
    float roll = atan2(ay, az);
    float pitch = atan2(-ax, sqrt(ay * ay + az * az));
// touchy trig stuff to use arctan to get compass heading (scale is 0..360)
    mx = -mx;
    float heading;
    if (my == 0.0)
        heading = (mx < 0.0) ? 180.0 : 0.0;
    else
        heading = atan2(mx, my)*360.0/(2.0*PI);
    //pc.printf("heading atan=%f \n\r",heading);
    heading -= DECLINATION; //correct for geo location
    if(heading>180.0) heading = heading - 360.0;
    else if(heading<-180.0) heading = 360.0 + heading;
    else if(heading<0.0) heading = 360.0  + heading;


    // Convert everything from radians to degrees:
    //heading *= 180.0 / PI;
    pitch *= 180.0 / PI;
    roll  *= 180.0 / PI;

    //pc.printf("Pitch: %f,    Roll: %f degress\n\r",pitch,roll);
    //pc.printf("Magnetic Heading: %f degress\n\r",heading);
    return heading;
}




int main()
{
    //LSM9DS1 lol(p9, p10, 0x6B, 0x1E);
    LSM9DS1 IMU(p28, p27, 0xD6, 0x3C);
    pb1.mode(PullUp);
    IMU.begin();
    float forward;
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    led3 = 1;
    wait(1);
    IMU.calibrate(1);
    led3 = 0;
    led1 = 1;
    wait(0.5);
    led4 = 1;
    wait(0.5);
    IMU.calibrateMag(0);
    led4 = 0;
    led2 = 1;

    //Get forward direction relative to user
    pc.printf("Press button to set forward direction");
    while(pb1 == 1) {
        IMU.readMag();
        IMU.readAccel();
        forward = printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),
                                IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));;
    }
    pc.printf("forward: %f\n\r", forward);
    while(1) {
        while(!IMU.tempAvailable());
        IMU.readTemp();
        while(!IMU.magAvailable(X_AXIS));
        IMU.readMag();
        while(!IMU.accelAvailable());
        IMU.readAccel();
        while(!IMU.gyroAvailable());
        IMU.readGyro();
        if(abs(IMU.calcGyro(IMU.gy)) > 100) {


            IMU.readAccel();

            IMU.readMag();


            //Calculate heading relative to forward direction
            float currHeading = printAttitude(IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az), IMU.calcMag(IMU.mx),IMU.calcMag(IMU.my), IMU.calcMag(IMU.mz));
            currHeading = correctHeading(currHeading, forward) + 45;
            //Start timeout to detect when stopped walking
            walkingTimer.attach(printStop, 0.3);

            //Detect direction and send command to main mbed
            if((currHeading > 270 && currHeading < 360) && !isWalking) {

                wireless.sendDirection(DIR_LEFT);

                isWalking = true;
            } else if((currHeading > 90 && currHeading < 180) && !isWalking) {

               wireless.sendDirection(DIR_RIGHT);
                isWalking = true;
            } else if((currHeading > 180 && currHeading < 270) && !isWalking) {

                wireless.sendDirection(DIR_DOWN);
                isWalking = true;
            } else if((currHeading > 360 || currHeading < 90) && !isWalking) {

                wireless.sendDirection(DIR_UP);
                isWalking = true;
            }
        }
    }
}

