#include "draw.h"

void draw_hitbox_ship(short posX, short posY){
    lcd.SetTextColor(LCD_COLOR_RED);
    lcd.DrawRect(posX,posY-height_wing,lenght_X_hitbox,lenght_Y_hitbox);  
    lcd.SetTextColor(LCD_COLOR_GREEN);  
}

void draw_star(short X, short Y){
    char star[5][5]={{1,0,1,0,1},
                     {0,0,1,0,0},
                     {1,1,0,1,1},
                     {0,0,1,0,0},
                     {1,0,1,0,1}} ;
    short i,j;  
    for(i=0;i<5;i++){
        for(j=0;j<5;j++){
            if(star[j][i]==0){ 
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_BLACK);
            }
            else{
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_YELLOW);
            }
        }
    }     
}

void draw_fire(short X,short Y, short fire){
    char fire1[10][10]={{1,1,0,0,0,1,0,0,0,0}, 
                        {0,0,1,1,0,0,1,0,0,0},
                        {0,0,0,0,1,1,2,1,0,0},
                        {0,0,1,1,2,2,2,2,1,0},
                        {1,1,2,2,2,2,2,2,2,1},
                        {1,1,2,2,2,2,2,2,2,1},
                        {0,0,1,1,2,2,2,2,1,0},
                        {0,0,0,0,1,1,2,1,0,0},
                        {0,0,1,1,0,0,1,0,0,0},
                        {1,1,0,0,0,1,0,0,0,0}}; 
                         
    char fire2[10][10]={{0,0,0,0,0,0,0,0,0,0}, 
                        {0,0,0,0,0,0,0,0,0,0},
                        {0,0,0,0,0,0,1,1,0,0},
                        {0,0,0,0,0,1,2,2,1,0},
                        {0,0,0,0,1,2,2,2,2,1},
                        {0,0,0,0,1,2,2,2,2,1},
                        {0,0,0,0,0,1,2,2,1,0},
                        {0,0,0,0,0,0,1,1,0,0},
                        {0,0,0,0,0,0,0,0,0,0},
                        {0,0,0,0,0,0,0,0,0,0}};  
    short i,j;  
    X=X-10;
    
    for(i=0;i<10;i++){
        for(j=0;j<10;j++){
            if(fire == 0){
                if(fire1[j][i]==0){ 
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_BLACK);
                }
                else if(fire1[j][i]==1){
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_YELLOW);
                }
                else if(fire1[j][i]==2){
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_RED);
                }
            }
            else{
                if(fire2[j][i]==0){ 
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_BLACK);
                }
                else if(fire2[j][i]==1){
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_YELLOW);
                }
                else if(fire2[j][i]==2){
                    lcd.DrawPixel(X+i,Y+j,LCD_COLOR_RED);
                }                
            }
        }
    } 
}

void draw_planet(short X,short Y){
    char planet[14][20]={
        {0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,3,4,4,4,3,4,4,3,0,0,0,0,0,0},
        {0,0,5,5,5,3,3,3,4,4,3,3,4,4,3,0,0,0,0,0},
        {5,5,5,5,3,4,4,3,3,4,4,3,3,4,4,3,5,5,0,0},
        {5,5,0,0,3,4,4,4,3,3,3,4,3,3,4,3,5,5,5,5},
        {5,5,0,3,3,4,4,4,4,3,3,3,4,3,3,3,3,0,5,5},
        {0,5,5,3,3,4,4,4,4,4,4,3,3,4,4,3,3,5,5,0},
        {0,5,5,5,3,4,4,4,4,4,4,4,3,3,3,5,5,5,0,0},
        {0,0,5,5,5,5,5,4,4,4,4,4,5,5,5,5,5,0,0,0},
        {0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0},
        {0,0,0,0,0,0,3,5,5,5,5,5,4,3,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0},//
        {0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0}
        };    
    short i,j;  
    
    for(i=0;i<20;i++){
        for(j=0;j<14;j++){
            if(planet[j][i]==0){ 
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_BLACK);
            }
            else if (planet[j][i]==3){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_MAGENTA);
            }
            else if (planet[j][i]==4){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_CYAN);
            }
            else if (planet[j][i]==5){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_ORANGE);
            }
        }
    } 
}

void draw_load(short X, short Y){   
    short i,j,progress;
    char convert_progress[5]={0};
    Y=Y+4;
    
    for(progress=0;progress<100;progress++){
        for(i=0;i<progress;i++){
            for(j=0;j<10;j++){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_GREEN);
            }
        } 
        sprintf(convert_progress,"%hd%%",progress);
        lcd.DisplayStringAt(300, LINE(7), (uint8_t *)convert_progress,LEFT_MODE);  
        wait(0.1);
    }      
}

void draw_hit(short X,short Y){
    char explosion[10][10]={
        {2,0,0,0,1,1,0,0,0,2},    
        {0,2,2,0,1,1,0,2,2,0}, 
        {0,2,0,2,1,1,2,0,2,0}, 
        {0,0,2,2,1,1,2,2,0,0}, 
        {1,1,1,1,2,2,1,1,1,1}, 
        {1,1,1,1,2,2,1,1,1,1},    
        {0,0,2,2,1,1,2,2,0,0}, 
        {0,2,0,2,1,1,2,0,2,0}, 
        {0,2,2,0,1,1,0,2,2,0}, 
        {2,0,0,0,1,1,0,0,0,2}};
    short i,j; 
     
    for(i=0;i<10;i++){
        for(j=0;j<10;j++){
            if(explosion[j][i]==0){ 
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_BLACK);
            }
            else if (explosion[j][i]==1){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_YELLOW);
            }
            else if (explosion[j][i]==2){
                lcd.DrawPixel(X+i,Y+j,LCD_COLOR_RED);
            }
        }
    }    
} 

void draw_ship(short posX, short posY, bool hitbox, short fire){   
    //body
    lcd.DrawRect(posX,posY,bodyX,bodyY); 
    //nose
    lcd.DrawLine(posX+bodyX,posY,posX+bodyX+lenght_nose,posY+height_nose );   
    lcd.DrawLine(posX+bodyX,posY+bodyY,posX+bodyX+lenght_nose,posY+height_nose );  
    //up wing
    lcd.DrawLine(posX,posY,posX,posY-height_wing);   
    lcd.DrawLine(posX+lenght_wing,posY,posX,posY-height_wing);
    //down wing
    lcd.DrawLine(posX,posY+bodyY,posX,posY+bodyY+height_wing);   
    lcd.DrawLine(posX+lenght_wing,posY+bodyY,posX,posY+bodyY+height_wing);
    
    draw_fire(posX,posY,fire);
    //hitbox
    if (hitbox){
        draw_hitbox_ship(posX,posY);    
    } 
}
bool draw_line(short posX, short posY, short lenght,short posX_ship, short posY_ship){
    short coord_slide_line;
    bool hit = false;
    bool flag_hit = false;
    
    posY_ship = posY_ship - height_wing;
    lcd.DrawLine(posX,posY,posX,posY+lenght); 
    
    if(posX>posX_ship and posX<posX_ship+lenght_X_hitbox){
        for(coord_slide_line=posY;coord_slide_line<=posY+lenght;coord_slide_line++){
            
            if(coord_slide_line>posY_ship and coord_slide_line<posY_ship+lenght_Y_hitbox){    
                hit = true; 
                if(flag_hit == false){
                    draw_hit(posX,coord_slide_line);
                    flag_hit = true;
                }
            }  
        }
    }
    return hit;      
}    