#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include "LCD_DISCO_F746NG.h"
#include "fonts.h"
#include "TS_DISCO_F746NG.h"

#include "draw.h"
#include "display.h"
#include "accelerometre.h"

#define line_speed  2
#define line_speed2 4
#define line_speed3 6

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
short lenght_X_hitbox = bodyX + lenght_nose;
short lenght_Y_hitbox = bodyY + 2*height_wing;



int main()
{
    TS_StateTypeDef TS_State;
    
    bool hit = false;
    bool hit2 = false;
    bool hit3 = false;
    bool hit4 = false;
    bool hit5 = false;
    short fire_frame=0;
    
    short int score = 0,best = 0;
    
    short posX_line = 0;
    short posX_line2 = 0;
    short posX_line3 = 0;
    short posX_ship = 0;
    short posY_ship = 0;
    short index_star = 0;
    short Xaccelerate=0;
    short Yaccelerate=0;
    short speed_difficulty=0,flag_level_difficulty=0;
    
    short pos_star[10][2]={{50,47},{102,97},{49,250},{253,127},{380,142},{200,200},{150,150},{370,250},{253,200},{100,142}};
    uint8_t status;
    bool continuer=true;
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    lcd.SetBackColor(LCD_COLOR_BLACK);
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"welcome to", CENTER_MODE);
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"ESCAPE THE LINE", CENTER_MODE);
    draw_load(190, LINE(7));
    lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"Touch to start!", CENTER_MODE);
    while(continuer){
        ts.GetState(&TS_State);
        if(TS_State.touchDetected)continuer=false;
    }
    
    lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Escape the line v1.0", LEFT_MODE); 
    lcd.DrawHLine(0,YMIN,480);  
    lcd.DrawVLine(XMAX,YMIN,YMAX-YMIN);
    lcd.DisplayStringAt(XMAX+2, YMIN+2, (uint8_t *)"Score",LEFT_MODE); 
    display_score(score);
    lcd.DisplayStringAt(XMAX+2, YMIN+2+24+2+24, (uint8_t *)"Best",LEFT_MODE); 
    while(1) {
        
            Xaccelerate = i2c_X_axis_read()*10*2;
            Yaccelerate = i2c_Y_axis_read()*10*2;
            
            posX_ship = posX_ship+Xaccelerate;            
            if(posX_ship<XMIN) posX_ship=XMIN;
            if(posX_ship>XMAX-lenght_X_hitbox) posX_ship=XMAX-lenght_X_hitbox-5;
            
            posY_ship = posY_ship+Yaccelerate;            
            if(posY_ship<YMIN+height_wing) posY_ship=YMIN+height_wing+5;
            if(posY_ship>YMAX-lenght_Y_hitbox+height_wing) posY_ship=YMAX-lenght_Y_hitbox+height_wing;
            
            posX_line = posX_line-line_speed-speed_difficulty;
            if(posX_line<XMIN)posX_line=XMAX;
            
            posX_line2 = posX_line2-line_speed2-speed_difficulty;
            if(posX_line2<XMIN)posX_line2=XMAX;
            
            posX_line3 = posX_line3-line_speed3-speed_difficulty;
            if(posX_line3<XMIN)posX_line3=XMAX;
            
             
            cls_scr();
            for(index_star=0;index_star<10;index_star++){
                draw_star(pos_star[index_star][0],pos_star[index_star][1]);    
            }
            draw_planet(230,100);
            draw_planet(100,230);
            draw_ship(posX_ship,posY_ship,false,fire_frame);
            hit = draw_line(posX_line,YMIN+100,40,posX_ship,posY_ship);
            hit2 = draw_line(posX_line3,YMIN,40,posX_ship,posY_ship);
            hit3 = draw_line(posX_line,YMAX-40,40,posX_ship,posY_ship);
            hit4 = draw_line(posX_line2,YMIN+45,40,posX_ship,posY_ship);
            hit5 = draw_line(posX_line3,YMIN+145,40,posX_ship,posY_ship);
            score += 1;
            if(score>1000 && flag_level_difficulty == 3){
                speed_difficulty+=5;
                flag_level_difficulty=4;
            }
            if(score>750 && flag_level_difficulty == 2){
                speed_difficulty+=2;
                flag_level_difficulty=3;
            }
            if(score>500 && flag_level_difficulty == 1){
                speed_difficulty+=2;
                flag_level_difficulty=2;
            }
            if(score>250 && flag_level_difficulty == 0){
                speed_difficulty+=2;
                flag_level_difficulty=1;
            }
            fire_frame ++;
            fire_frame = fire_frame%2;
            if(hit == true || hit2 == true || hit3 == true || hit4 == true || hit5 == true ){
                if(score>best){
                    best=score;
                    died(1);
                }
                else{
                    died(0);
                }
                display_best(best);
                score = 0;
                posX_ship = 0;
                posX_line = XMAX;
                posX_line2 = XMAX;
                posX_line3 = XMAX;
                speed_difficulty=0;
                hit = false;
            }
            display_score(score);
            wait(0.05);       
    }
}


