// SerialIO.cpp : Defines the entry point for the console application.

#include "stdafx.h"
#include <windows.h>
#include <stdio.h>
#include "listCOM.h"
#include <iostream>
#include <fstream>
#include <string>
#include <ctype.h>

using namespace std;

#define FEED 10
#define END_OF_TRANSMISSION 23

BOOL ModifyCommSettings(HANDLE hComPort);
HANDLE hSerial;

int openConn()
{
	DWORD cBytes_out, cBytes_in;
	DWORD dwMask;
	
	char cBuffer_in[2];
	cBuffer_in[1] = 0;
	// Display message on console
	printf("\nOpening Serial Port \n\r");

	// Open Serial Port COMx: for Read and Write
	hSerial = CreateFile((LPCWSTR)my_port, GENERIC_READ | GENERIC_WRITE, 0, NULL,
		OPEN_EXISTING, 0, NULL);
	// Check for file open errors
	if (hSerial == INVALID_HANDLE_VALUE){
		printf("file open errors\n");
		Sleep(4000);
		return 0;
	}
	// Modify Com Port settings (i.e. Baud Rate, #bits, parity etc)
	if (!ModifyCommSettings(hSerial)){
		printf("com port settings errors\n");
		Sleep(4000);
		return 0;
	}
	printf("\n Opened Serial Connection with mbed \n\r Ctrl C to exit\n\r");

	// Set Communication event mask for WaitCommEvent for rxchar (receive character) in buffer
	SetCommMask(hSerial, EV_RXCHAR | EV_ERR);

	//	Setting up the reading of the text file
	ifstream iFile("C:\\ECE4180\\hellombed.gcode");
	if (iFile) printf("\n Gcode file opened successfully\r\n");

	string line;
	// creating a pointer to char to store the C version of the line string
	char* c_line;

	cBuffer_in[0] = 0;
	// reading the gcode file line by line
	while (getline(iFile, line)){
	
		// finding the length of the message
		cBytes_out = line.length() + 1;
		// allocating space for C representation of string to be sent over serial 
		c_line = new char[cBytes_out];

		//coyping data to C string c_line
		strcpy_s(c_line, cBytes_out, line.c_str());

		cout << c_line << "\r\n";
		
		// checking that the line contains a valid command.
		// TODO: only checking for starting command being a G#*, might have invalid args that are not checked
		if (c_line[0] == 'G' && isdigit(c_line[1])){
			// sending the line over the serial link
			if (!WriteFile(hSerial, c_line, cBytes_out, &cBytes_out, NULL)){
				printf("\rFile write errors\n");
				Sleep(4000);
				return 0;
			}

			// deleting the dynamic buffer after sending
			delete[] c_line;
		}
		// if the line does not have a command continue to the next line
		else{ 
			// deleting the dynamic buffer after sending
			delete[] c_line;
			continue;
		}

		// Wait for character to be sent back to UARTs input buffer - events are more efficient than looping
		WaitCommEvent(hSerial, &dwMask, 0);

		cBuffer_in[0] = 0;
		// Loop until receiving the FEED signal
		while (cBuffer_in[0] != FEED){
			// Read constantly waiting for FEED character 
			ReadFile(hSerial, cBuffer_in, 1, &cBytes_in, NULL);

			/*
			// Read any serial data and display
			if (ReadFile(hSerial, cBuffer_in, 1, &cBytes_in, NULL)){

				cout << cBuffer_in << "\r\n";
				cout << cBytes_in << " bytes received \r\n";
			}
			*/
		} //while cBuffer_in[0] != FEED
	} // while getline

	// after the last line has been sent, sent the end of transmission message
	c_line[0] = END_OF_TRANSMISSION;
	c_line[1] = 0;	// NULL terminate the string
	cBytes_out = 2;

	// attempt until message is sent
	while (!WriteFile(hSerial, c_line, cBytes_out, &cBytes_out, NULL));

	string input;
	cout << "Press any key followed by ENTER to exit...\n>";
	cin >> input;

	// Close Files
	iFile.close();
	CloseHandle(hSerial);
	return 0;
}

BOOL   ModifyCommSettings(HANDLE hComPort)
{
	COMMTIMEOUTS ctos;
	DCB PortDCB;
	// Initialize the DCBlength member. 
	PortDCB.DCBlength = sizeof (DCB);
	// Get the default serial port settings DCB information.
	GetCommState(hSerial, &PortDCB);
	// Change the common DCB structure settings to modify serial port settings.
	PortDCB.BaudRate = 921600;              // Current baud 
	PortDCB.fBinary = TRUE;               // Binary mode; no EOF check 
	PortDCB.fParity = TRUE;               // Enable parity checking 
	PortDCB.fOutxCtsFlow = FALSE;         // No CTS output flow control 
	PortDCB.fOutxDsrFlow = FALSE;         // No DSR output flow control 
	PortDCB.fDtrControl = DTR_CONTROL_ENABLE; // DTR flow control type 
	PortDCB.fDsrSensitivity = FALSE;      // DSR sensitivity 
	PortDCB.fTXContinueOnXoff = TRUE;     // XOFF continues Tx 
	PortDCB.fOutX = FALSE;                // No XON/XOFF out flow control 
	PortDCB.fInX = FALSE;                 // No XON/XOFF in flow control 
	PortDCB.fErrorChar = FALSE;           // Disable error replacement 
	PortDCB.fNull = FALSE;                // Disable null stripping 
	PortDCB.fRtsControl = RTS_CONTROL_ENABLE; // RTS flow control 
	PortDCB.fAbortOnError = FALSE;        // Do not abort reads/writes on error
	PortDCB.ByteSize = 8;                 // Number of bits/byte, 4-8 
	PortDCB.Parity = NOPARITY;            // 0-4=no,odd,even,mark,space 
	PortDCB.StopBits = ONESTOPBIT;        // 0,1,2 = 1, 1.5, 2 
	// Configure the port settings according to the new specifications  
	// of the DCB structure.
	if (!SetCommState(hSerial, &PortDCB)){
		printf("Unable to configure the serial port");
		Sleep(4000);
		return false;
	}
	// Set read time outs 
	ctos.ReadIntervalTimeout = MAXDWORD;
	ctos.ReadTotalTimeoutMultiplier = MAXDWORD;
	ctos.ReadTotalTimeoutConstant = 1;
	ctos.WriteTotalTimeoutMultiplier = 0;
	ctos.WriteTotalTimeoutConstant = 0;
	if (!SetCommTimeouts(hSerial, &ctos)){
		printf("Unable to configure the serial port");
		Sleep(4000);
		return false;
	}
	return true;
}

