#ifndef PEN_H
#define PEN_H

#include "mbed.h"

class Pen {
    
    public:
        Pen(PinName p, float r);
        ~Pen();
        
        void up();
        void down();
        void pos(float angle);
        
    private:
        PwmOut* pen_pin;
        float range;
        float up_range, down_range;
    
};

Pen::Pen(PinName p, float r) {
    range = r;
    up_range = 1;
    down_range = 1+90.0/range;
    pen_pin = new PwmOut(p);
    pen_pin->period_ms(20);
    up();
}

Pen::~Pen() {
    delete pen_pin;
}

// Go to angle in degrees
inline void Pen::pos(float angle) {
    pen_pin->pulsewidth_ms(1+angle/range); 
}

inline void Pen::up() {
    pen_pin->pulsewidth_ms(up_range); 
}

inline void Pen::down() {
    pen_pin->pulsewidth_ms(down_range);
}

#endif