#include "mbed.h"
#include "capSense.h"
#include "uLCD_4DGL.h"


#define RA 19770    // ohms
#define RB 9053    // ohms
#define PERIOD 2000000  //us
 
uLCD_4DGL uLCD(p9, p10, p11);    // lcd connection
CapSense cap(RA, RB, PERIOD, p21);

int main() {
    uLCD.locate(3,5);   //setting the cursor to the middle

    while(1) {
        uLCD.locate(0,6);   // setting cursor    
        float capacitance = cap.measure();    
        uLCD.printf("Capacitance:\n%f uF   \n\n", capacitance);
        uLCD.printf("Frequency:\n%f Hz        ",(float)cap._count/PERIOD*1000000);
    }   
}