/* This program makes a sine wave. This converts 360 degrees 
into radian every once from 0 and gives it in sine function. 
The value multiply 0.5 by the result of the calculation and add 0.5 
to give an offset voltage. As for the value that calculated, 
it becomes a sin wave of center level 1.65V, 0V at the minimum,
up to 3.3V with a DA converter in this way. 
The sine wave is stored in a local file. Extension is .CSV. 
You can make a graph by Excel and confirm a sine wave.
*/
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

LocalFileSystem local("local");
DigitalOut busy(LED2);
AnalogOut DA(p18);
AnalogIn AD(p20);

int main() {
    lcd.printf("SinWave\n");
    FILE *fp;

    if ( NULL == (fp = fopen( "/local/sinewave.csv", "w" )) )
        error( "" );

    busy  = 1;

    for (float i=0; i<360; i++) {
        DA = sin(i/180*3.14)*0.5+0.5;
        wait(0.05);
        lcd.locate(0,1);
        lcd.printf("DA out %0.5fV", AD.read()*3.3);
        fprintf( fp, "%f\n", (float)AD.read()*3.3 );
    }
    fclose( fp );
    busy   = 0;
}
