/* I made the digital watch which set the start time in ntp. 
It's same as "clock" see:[http://mbed.org/users/jf1vrr/programs/clock/lpucqk] 
except that I changed from unix timezone to ntp.
*/
#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
EthernetNetIf eth; 
NTPClient ntp;

int offset_JAPAN = 32400;

int main() {
    /* Set up Ethernet */
    lcd.cls();
    lcd.printf("Setting up Eth\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.cls();
        lcd.printf("Error with Eth\nNum: %d", ethErr);
        return -1;
    }   
    
    /* Set up NTP */
    lcd.printf("Setting up NTP\n");
    Host server(IpAddr(), 123, "ntp1.jst.mfeed.ad.jp");
    ntp.setTime(server);
    
    lcd.cls();    
    while(1) {
        time_t seconds = time(NULL)+offset_JAPAN;

        lcd.locate(0,0);
        char day[16];
        strftime(day, 16, "%Y/%m/%d %a\n", localtime(&seconds));
        lcd.printf("%s", day);
        
        char time[16];
        strftime(time, 16, "%H:%M:%S\n", localtime(&seconds));
        lcd.locate(0,1);
        lcd.printf("%s", time);

        wait(1.0);
    }
}
