/* I made a clock in mbed. mbed has RTC built-in. 
A convenient function is prepared for in the rtc_time 
function group of mbed.h. Because data are provided 
at the time when they give unix timestamp and ask it 
at suitable distance, a format to like it can be set 
and displays it to LCD. If unix timestamp is provided 
from web, it becomes more convenient.
*/
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
int offset_JAPAN = 32400;

int main() {
    set_time(1303099200+offset_JAPAN);  // Set RTC time to Mon, 18 Apr 2011 13:00:00

    lcd.cls();    
    while(1) {
        time_t seconds = time(NULL);

        lcd.locate(0,0);
        char day[16];
        strftime(day, 16, "%Y/%m/%d %a\n", localtime(&seconds));
        lcd.printf("%s", day);
        
        char time[16];
        strftime(time, 16, "%H:%M:%S\n", localtime(&seconds));
        lcd.locate(0,1);
        lcd.printf("%s", time);

        wait(1.0);
    }
}
