/*This program makes the WAV file of the sinewave in a local file. 
The sampling frequency is 8KHz. In other words, it is the quality of the 
telephone. The quantization precision is 16 bits. You can change the 
frequency of the sinewave, the amplitude by changing a parameter in the 
top of the program. You can change the file name, too. I suggest that 
you make the plain name later. You can listen the wav file which You made 
in Windows Mediaplayer.
*/

/*This program is made in reference to "Sound Programming in C Language" by Aoki Naofumi"*/

#define FREQ 440 //Frequency (Hz) 
#define AMP 0.5 //Amplitude 0 - 1
#define FILE_NAME "/local/440_05.wav"  //Data file name max 8char.wav fffff_aa.wav

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

LocalFileSystem local("local");
DigitalOut led_1(LED1);
DigitalOut led_2(LED2);
DigitalOut led_3(LED3);
DigitalOut led_4(LED4);

int main(void)
{
  typedef struct
  {
    int fs;
    int bits;
    int length;
    double *s;
  } MONO_PCM;
  
  FILE *fp;
  MONO_PCM pcm;
  int i, j;
  double s;
  short data;
  double A, f0;
  
  char riff_chunk_ID[4];
  long riff_chunk_size;
  char riff_form_type[4];
  char fmt_chunk_ID[4];
  long fmt_chunk_size;
  short fmt_wave_format_type;
  short fmt_channel;
  long fmt_samples_per_sec;
  long fmt_bytes_per_sec;
  short fmt_block_size;
  short fmt_bits_per_sample;
  char data_chunk_ID[4];
  long data_chunk_size;
  
  lcd.cls();
  lcd.locate(0,0);
  lcd.printf("Audio wave\n");
  
  int block_length = 1000;
  
  pcm.fs = 8000;
  pcm.bits = 16;
  pcm.length = 40000; //about 5sec
  pcm.s = (double*) calloc(block_length, sizeof(double)); 
    
  A = AMP;
  f0 = FREQ;
  
  if ( NULL == (fp = fopen(FILE_NAME, "wb" )) )
    error( "" );
  
  led_1 = 1;
  riff_chunk_ID[0] = 'R';
  riff_chunk_ID[1] = 'I';
  riff_chunk_ID[2] = 'F';
  riff_chunk_ID[3] = 'F';
  riff_chunk_size = 36 + pcm.length * 2;
  riff_form_type[0] = 'W';
  riff_form_type[1] = 'A';
  riff_form_type[2] = 'V';
  riff_form_type[3] = 'E';
  
  fmt_chunk_ID[0] = 'f';
  fmt_chunk_ID[1] = 'm';
  fmt_chunk_ID[2] = 't';
  fmt_chunk_ID[3] = ' ';
  fmt_chunk_size = 16;
  fmt_wave_format_type = 1;
  fmt_channel = 1;
  fmt_samples_per_sec = pcm.fs;
  fmt_bytes_per_sec = pcm.fs * pcm.bits / 8;
  fmt_block_size = pcm.bits / 8;
  fmt_bits_per_sample = pcm.bits;
  
  data_chunk_ID[0] = 'd';
  data_chunk_ID[1] = 'a';
  data_chunk_ID[2] = 't';
  data_chunk_ID[3] = 'a';
  data_chunk_size = pcm.length * 2;
  
  fwrite(riff_chunk_ID, 1, 4, fp);
  fwrite(&riff_chunk_size, 4, 1, fp);
  fwrite(riff_form_type, 1, 4, fp);
  fwrite(fmt_chunk_ID, 1, 4, fp);
  fwrite(&fmt_chunk_size, 4, 1, fp);
  fwrite(&fmt_wave_format_type, 2, 1, fp);
  fwrite(&fmt_channel, 2, 1, fp);
  fwrite(&fmt_samples_per_sec, 4, 1, fp);
  fwrite(&fmt_bytes_per_sec, 4, 1, fp);
  fwrite(&fmt_block_size, 2, 1, fp);
  fwrite(&fmt_bits_per_sample, 2, 1, fp);
  fwrite(data_chunk_ID, 1, 4, fp);
  fwrite(&data_chunk_size, 4, 1, fp);
  wait(0.5);
  led_1 = 0;
    
  led_2 = 1;
  for(i = 0; i < pcm.length/block_length; i++)
  {

    for (j = 0; j < block_length; j++)
    { 
      pcm.s[j] = A * sin(2.0 * 3.141592 * f0 * (i * block_length + j) / pcm.fs);
      s = (pcm.s[j] + 1.0) / 2.0 * 65536.0;
    
      if (s > 65535.0) s = 65535.0; 
      else if (s < 0.0) s = 0.0; 
    
      data = (short)(s + 0.5) - 32768;
      fwrite(&data, 2, 1, fp);
    }
  }
  led_2 = 0;
  fclose(fp);   
  free(pcm.s);
  
  lcd.locate(0,1);
  lcd.printf("Done!\n");
  
  return 0;
}