/* This program outputs the voltage to a DA converter 
and inputs it into AD converter and displays it to LCD. 
The voltage changes it to 3.3V by a 0.033 volts step 
from 0 volts and displays it every 0.5 seconds. 
DA port is p18. AD port is p20. It is necessary to 
short-circuit with a wire in p18 and p20 before 
executing a program. The voltage that output to a 
DA converter is displayed by the first line of the LCD. 
The voltage that read with AD converter is displayed 
by the second line of the LCD.
*/
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

AnalogOut daval(p18);
AnalogIn adval(p20);

int main() {
    //lcd.printf("Analog out test\n");
    while(1) {
        for(float i=0.0; i<1.0; i+=0.01) {
            lcd.locate(0,0);
            lcd.printf("D/A out %0.2fV",i*3.3);
            daval = i;
            wait(0.05);
            lcd.locate(0,1);
            lcd.printf("A/D in  %0.2fV",adval.read()*3.3);
            wait(0.5);
        }
    }
}
