/*
This is the clock which used highly quality RTC module RT8564NB. 
This module is I2C controllable. At the time of poweron/reset, the start 
time received from ntp server.

Revision History:
Rev. 0.01A 2011/04/26 New
Rev. 0.01B 2011/04/27 Add time justify function, sec LED 
 */
#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"

#define RTC8564NB_ADR 0xA2

#define CONTROL1 0x00
#define CONTROL2 0x01
#define SECONDS 0x02
#define MINUTES 0x03
#define HOURS 0x04
#define DAYS 0x05
#define WEEKDAYS 0x06
#define MONTHS 0x07
#define YEARS 0x08
#define MINUTE_ALARM 0x09
#define HOUR_ALARM 0x0A
#define DAY_ALARM 0x0B
#define WEEKDAY_ALARM 0x0C
#define CLOCKOUT_FREQ 0x0D
#define TIMER_CINTROL 0x0E
#define TIMER 0x0F
#define _READ 0x01

TextLCD lcd(p24, p26, p27, p28, p29, p30);
EthernetNetIf eth; 
NTPClient ntp;
I2C i2c(p9, p10);
DigitalOut sec_led(LED1);
DigitalOut test_led(LED2);
InterruptIn just_button(p15);

int offset_JAPAN = 32400;

char year, month, day, week;
char hour, minute, sec;
char ntp_year[3], ntp_month[3], ntp_day[3], ntp_week[4];
char ntp_hour[3], ntp_minute[3], ntp_sec[3];
char week_val;

char week_chr[7][4] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
    
void rtc_write(char address, char value)
{
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.write(value);
    i2c.stop();
}

char rtc_read(char address)
{
    char value;
    i2c.start();
    i2c.write(RTC8564NB_ADR);
    i2c.write(address);
    i2c.start();
    i2c.write(RTC8564NB_ADR | _READ);
    value = i2c.read(0);
    i2c.stop();
    
    return value;
}

void time_just()
{
    char _min, _hour;
    test_led = !test_led;
    _min = rtc_read(MINUTES);
    if (_min >= 0x30) { 
            _hour = rtc_read(HOURS);
            if (_hour == 0x23)
                _hour = 0x00;
            else if ((_hour & 0x0F) == 0x09)
                _hour = (_hour & 0xF0) + 0x10;
            else
                _hour = _hour + 0x01;
            rtc_write(HOURS, _hour);
    }
    rtc_write(MINUTES, 0x00);
    rtc_write(SECONDS, 0x00);
}
    
int main() {
    just_button.rise(&time_just);

    lcd.cls();
    lcd.printf("RTC8564NB CLOCK" );
    wait(2.0);
    
    /* Set up Ethernet */
    lcd.cls();
    lcd.printf("Setting up Eth\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.cls();
        lcd.printf("Error with Eth\nNum: %d", ethErr);
        return -1;
    }   
    
    /* Set up NTP */
    lcd.printf("Setting up NTP\n");
    Host server(IpAddr(), 123, "ntp1.jst.mfeed.ad.jp");
    ntp.setTime(server);
    
    time_t seconds = time(NULL)+offset_JAPAN;
    
    lcd.cls();
    strftime(ntp_year, 16, "%y", localtime(&seconds));
    strftime(ntp_month, 16, "%m", localtime(&seconds));
    strftime(ntp_day, 16, "%d", localtime(&seconds));
    strftime(ntp_week, 16, "%a", localtime(&seconds));
    strftime(ntp_hour, 16, "%H", localtime(&seconds));
    strftime(ntp_minute, 16, "%M", localtime(&seconds));
    strftime(ntp_sec, 16, "%S", localtime(&seconds));
    
    switch (ntp_week[0]){
        case 'S': 
            switch (ntp_week[1]) {
                case 'u': week_val = 0x00; break;
                case 'a': week_val = 0x06; break;
            }
            break;
        case 'M': week_val = 0x01; break;
        case 'T': 
            switch (ntp_week[1]) {
                case 'u': week_val = 0x02; break;
                case 'h': week_val = 0x04; break;
            }
            break;
        case 'W': week_val = 0x03; break;
        case 'F': week_val = 0x05; break;
    }
        
    rtc_write(CONTROL1, 0x20); //stop
    rtc_write(CONTROL2, 0x00);
    rtc_write(YEARS, ((ntp_year[0]-0x30)<<4)+(ntp_year[1]-0x30)); 
    rtc_write(MONTHS, ((ntp_month[0]-0x30)<<4)+(ntp_month[1]-0x30));
    rtc_write(DAYS, ((ntp_day[0]-0x30)<<4)+(ntp_day[1]-0x30));
    rtc_write(HOURS, ((ntp_hour[0]-0x30)<<4)+(ntp_hour[1]-0x30));
    rtc_write(MINUTES, ((ntp_minute[0]-0x30)<<4)+(ntp_minute[1]-0x30));
    rtc_write(SECONDS, ((ntp_sec[0]-0x30)<<4)+(ntp_sec[1]-0x30));
    rtc_write(WEEKDAYS, week_val);
    rtc_write(CLOCKOUT_FREQ, 0x00); // 0x83 = TE on & 1Hz
    rtc_write(TIMER_CINTROL, 0x00);
    rtc_write(CONTROL1, 0x00); //start
    
    while(1) { 
        year = rtc_read(YEARS);
        month = rtc_read(MONTHS);
        day = rtc_read(DAYS);
        week = rtc_read(WEEKDAYS);
        hour = rtc_read(HOURS);
        minute = rtc_read(MINUTES);
        sec = rtc_read(SECONDS);
        lcd.locate(0,0);
        lcd.printf("20%c%c/%c%c/%c%c %s",
            ((year >> 4) & 0x03) + 0x30, (year & 0x0F) + 0x30, 
                ((month >> 4) & 0x01) + 0x30, (month & 0x0F) + 0x30, 
                    ((day >> 4) & 0x03)+ 0x30, (day & 0x0F) + 0x30, 
                        week_chr[week & 0x07]);
        lcd.locate(0,1); 
        lcd.printf("%c%c:%c%c:%c%c",
            ((hour >> 4) & 0x03) + 0x30, (hour & 0x0F) + 0x30, 
                (minute >> 4) + 0x30, (minute & 0x0F) + 0x30, 
                    (sec >> 4) + 0x30, (sec & 0x0F) + 0x30 );
        
        sec_led = !sec_led;
        wait(0.5);
    }
}
