/*This is a program to output a sinwave in 12 bits 
Digital to Analog converter MCP4922. Sampling frequency is 
166,667Hz and produce an interrupt of Ticker every 6uS. 
The Program calculates the data of the sinewave beforehand.
*/
#include "mbed.h"
#include "TextLCD.h"
#include "MCP4922.h"

MCP4922 MCP(p5, p7,p8);  // MOSI, SCLK, CS
TextLCD lcd(p24, p26, p27, p28, p29, p30);
Ticker sampling;

#define PI             3.141593
#define MaxRes         800
/// Global Variables
unsigned int           OutData[MaxRes];
unsigned int           Maxindex;
unsigned long          Fsample;
unsigned long          Freq;
unsigned int           index = 0;

void GenWave(void) {
        unsigned int i;

        Maxindex = (int) (Fsample / Freq);
        if(Maxindex > MaxRes) {
                Fsample = Freq * MaxRes;
                     Maxindex = MaxRes;
        }
        for(i=0; i<Maxindex; i++) {
                OutData[i] =  (int)(0x1FF * (1+ sin((2*PI*Freq*i)/Fsample))/2);
        }
}
void timer_int(){
        /// Output to D/A Converter
        MCP.writeA(OutData[index]);
        index++;
        if(index >= Maxindex) index = 0;
}

/**** Main Function  ***/
int main(void) {
        MCP.frequency(20000000);

        lcd.cls();
        lcd.printf("MCP4922 Sinewave");

        Fsample = 166667;
        Freq   = 1000;
        GenWave();

        sampling.attach_us(&timer_int, 6); 
        while(1){
        }
}