/*mbed EPROM 27256 Vpp 12.5V Writter
Functions
Blank Check(SW = 0): Check blank(all 1) erased EPROM
Write(SW = 1): Write Hex file(TEST1.HEX) to EPROM
Read: Read from EPROM and dump to local file(TEST1.DMP)
Copy: Read from dump image file(TEST1.DMP) and write to EPROM
*/
#include "mbed.h"
#include "TextLCD.h"

LocalFileSystem local("mbed");
BusInOut DATA(p5, p6, p7, p8, p9, p10, p11, p12);
BusOut ADRS(p13, p14);
DigitalOut RD(p15);
DigitalOut WR(p16);
DigitalOut RESET(p17);
DigitalOut CE(p18);
DigitalOut OE(p19);
DigitalOut VCP_0V(p20);
DigitalOut VCP_5V(p21);
DigitalIn  BTN(p22);
BusIn SW(p23, p24);
TextLCD lcd(p25, p26, p27, p28, p29, p30);

DigitalOut LED_BUSY(LED1);
DigitalOut LED_5V(LED2);
DigitalOut LED_12V(LED3);
DigitalOut LED_RETRY(LED4);

#define _HIGH    1
#define _LOW     0

#define SET_READ   DATA.input()
#define SET_WRITE  DATA.output()

#define PORT_A  0
#define PORT_B  1
#define PORT_C  2
#define CONTRL  3

#define MAX_ADDRESS 1024

union UNION1{
    struct HEX{
        uint8_t marker;
        uint8_t length[2];
        uint8_t offset[4];
        uint8_t rectype[2];
        uint8_t data[64]; 
    } h;
    char    hex_line[137];
} u;

union UNION2{
    uint16_t    address;
    uint8_t     hl_address[2];
} a;

FILE *fp;
char hex_filename[] = "/mbed/test1.hex";
char out_filename[] = "/mbed/test1.dmp";
char in_filename[] = "/mbed/test1.dmp";

short ROM_write(uint8_t address_h, uint8_t address_l, short data_byte){
    short   read_byte;

    LED_BUSY = _HIGH;
    wait_us(1000);
    SET_WRITE;
    ADRS = CONTRL;
    DATA = 0x80;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;
    
    ADRS = PORT_A;
    DATA = address_l;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;

    ADRS = PORT_B;
    DATA = address_h;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;
    
    ADRS = PORT_C;
    DATA = data_byte;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;
    
    CE = _LOW;
    wait_us(100);
    CE = _HIGH;

    wait_us(10);
 
    ADRS = CONTRL;
    DATA = 0x89;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;
       
    ADRS = PORT_A;
    DATA = address_l;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;
    
    ADRS = PORT_B;
    DATA = address_h;
    WR = _LOW;
    wait_us(100);
    WR = _HIGH;

    SET_READ;
    ADRS = PORT_C;
    OE = _LOW;
    wait_us(100);
    RD = _LOW;
    wait_us(100);
    read_byte = DATA;
    wait_us(50);
    RD = _HIGH;
    OE = _HIGH;
    SET_WRITE;
    LED_BUSY = _LOW;

    return read_byte;  
}

uint8_t ROM_read(uint8_t address_h, uint8_t address_l){
    uint8_t   read_byte;

    LED_BUSY = _HIGH;
    SET_WRITE;
    ADRS = CONTRL;
    DATA = 0x89;
    WR = _LOW;
    wait_us(10);
    WR = _HIGH;
       
    ADRS = PORT_A;
    DATA = address_l;
    WR = _LOW;
    wait_us(10);
    WR = _HIGH;
    
    ADRS = PORT_B;
    DATA = address_h;
    WR = _LOW;
    wait_us(10);
    WR = _HIGH;
    
    SET_READ;
    ADRS = PORT_C;
    CE = _LOW;
    wait_us(10);    
    OE = _LOW;
    wait_us(10);
    RD = _LOW;
    wait_us(100);
    read_byte = DATA;
    wait_us(10);
    RD = _HIGH;
    OE = _HIGH;
    CE = _HIGH;
    
    SET_WRITE;
    LED_BUSY = _LOW;
    return read_byte;  
}

char h2d(char h_data){
    char d_data;

    d_data = 0;
    if(h_data <= '9') d_data = h_data - '0';
    else if(h_data >= 'A') d_data = h_data - 'A' + 10;
    return d_data;
}

void Vcc_5V_Vpp_5V(){
    LED_12V = _LOW;
    LED_5V = _HIGH;
    VCP_0V = _LOW;
    VCP_5V = _HIGH;
}

void Vcc_6V_Vpp_12V(){
    LED_5V = _LOW;
    LED_12V = _HIGH;
    VCP_0V = _LOW;
    VCP_5V = _LOW;
}

void Vcc_0V_Vpp_0V(){
    LED_5V = _LOW;
    LED_12V = _LOW;
    VCP_0V = _HIGH;
    VCP_5V = _LOW;
}

void get_btn(){
    int cnt;
    
    cnt = 0;
    lcd.locate(0, 1);
    lcd.printf("Push BTN to Cont");
    while(cnt < 30){
        if(BTN == _HIGH) cnt++;
    }
}

void blank_check(){
    uint8_t read_data;
        
    lcd.locate(0,0);
    lcd.printf("Blank Chk Mode  ");
    get_btn();
    
    Vcc_5V_Vpp_5V();
    for(a.address = 0; a.address < MAX_ADDRESS; a.address++){
        read_data = ROM_read(a.hl_address[1], a.hl_address[0]);
        lcd.locate(0,1);
        lcd.printf("%04X %02X         ", a.address, read_data);
        if( read_data != 0xFF) goto __BLNK_ERROR;
    }
    lcd.locate(0,0);
    lcd.printf("Success!        ");
    return;

__BLNK_ERROR:
    lcd.locate(0,1);
    lcd.printf("Blnk Check Error");
    return;      
} //blank_check()

void write_rom(){
    int i, len, line;
    int  sum, cs;
    short length, high_byte, low_byte;
    uint8_t write_data, read_data, rty_cnt;
    
    lcd.locate(0,0);
    lcd.printf("HEX WRITE to ROM");
    lcd.locate(0,1);
    lcd.printf(hex_filename);
    get_btn();
             
    if ( NULL == (fp = fopen( hex_filename, "r" )) )
        goto __HEX_FILE_OPEN_ERROR;

    line = 0;
    while(1){
        for(len = 0; len < 137; len++){
            u.hex_line[len] = fgetc(fp);
            if(feof(fp) != NULL) goto __EOF;
            if(u.hex_line[len] == 0x0A) goto __EXIT_FOR;
        }

__EXIT_FOR:    
        u.hex_line[len - 1] = NULL; //Remove CRLF and terminate
        line++;
        if(u.h.marker != ':') goto __MARKER_ERROR;
    
        length = 0;
        high_byte = h2d(u.h.length[0]) * 16;
        low_byte = h2d(u.h.length[1]);
        length = high_byte + low_byte; 
      
        a.hl_address[0] = (h2d(u.h.offset[2]) * 16) + h2d(u.h.offset[3]);
        a.hl_address[1] = (h2d(u.h.offset[0]) * 16) + h2d(u.h.offset[1]);
        Vcc_6V_Vpp_12V();
        for ( i = 0; i < length * 2; i= i + 2){
            high_byte = h2d(u.h.data[i]) * 16;
            low_byte = h2d(u.h.data[i + 1]);
            write_data = high_byte + low_byte; 
            for(rty_cnt = 0; rty_cnt <= 25; rty_cnt++){
                if(rty_cnt > 0) LED_RETRY = _HIGH;
                read_data = ROM_write(a.hl_address[1], a.hl_address[0], write_data);
                lcd.locate(0,0);
                lcd.printf(" %03d %04X %02X %02X", line, a.address, write_data, read_data);
                lcd.locate(0,1);
                lcd.printf("              %02D", rty_cnt);
                if(read_data == write_data) goto __NEXT_ADDRS;
            }
            goto __RTY_ERROR;
            
__NEXT_ADDRS:
            LED_RETRY = _LOW;
            a.address++;
        }
        Vcc_5V_Vpp_5V();    
        cs = 0; 
        i--;
        high_byte = h2d(u.h.data[i + 1]) * 16;    
        low_byte = h2d(u.h.data[i + 2]);
        cs = high_byte + low_byte; 

        //calc check sum
        sum = 0;
        for( i = 1; i < len - 3; i = i + 2){
            high_byte = h2d(u.hex_line[i]);
            high_byte = high_byte * 16;  
            low_byte = h2d(u.hex_line[i + 1]);
            sum = sum + high_byte + low_byte;      
        }

        if(((0x100 - (sum & 0xFF)) - cs) != 0) goto __CS_ERROR;

    } //while(1)
    lcd.locate(0,0);
    lcd.printf("Success!        ");
    return; 

__HEX_FILE_OPEN_ERROR:
    lcd.locate(0,1);
    lcd.printf("HEX File Open Er");
    return;
         
__MARKER_ERROR:
    lcd.locate(0,1);
    lcd.printf("Marker Error!");
    return;
    
__CS_ERROR:
    lcd.locate(0,1);
    lcd.printf("Check Sum Error!");
    return;
    
__EOF:
    lcd.locate(0,1);
    lcd.printf("End Of File     ");
    return;
          
__RTY_ERROR:
    lcd.locate(0,1);
    lcd.printf("Retry Error ");
    return;
} //write_rom()

void read_rom(){
    uint8_t read_data;
    
    lcd.locate(0,0);
    lcd.printf("READ from ROM   ");
    get_btn();

    if ( NULL == (fp = fopen( out_filename, "w" )) )
        goto __OUT_FILE_OPEN_ERROR;
            
    Vcc_5V_Vpp_5V();
    for(a.address = 0; a.address < MAX_ADDRESS; a.address++){
        read_data = ROM_read(a.hl_address[1], a.hl_address[0]);
        fprintf(fp, "%02X", read_data);
        lcd.locate(0,1);
        lcd.printf("%04X %02X         ", a.address, read_data);
        //wait(2);
    }
    lcd.locate(0,0);
    lcd.printf("Success!        ");
    return;
    
__OUT_FILE_OPEN_ERROR:
    lcd.locate(0,1);
    lcd.printf("Out File Open Er");
    return;
        
} //read_rom

void copy_rom(){
    int rty_cnt;
    char h_data, l_data;
    uint8_t read_data, write_data;
    
    lcd.locate(0,0);
    lcd.printf("COPY to ROM     ");
    get_btn();
 
    if ( NULL == (fp = fopen( in_filename, "r" )) )
        goto __IN_FILE_OPEN_ERROR;
            
    Vcc_6V_Vpp_12V();
    for(a.address = 0; a.address < MAX_ADDRESS; a.address++){
        h_data = fgetc(fp);
        l_data = fgetc(fp);
        write_data = h2d(h_data) * 16 + h2d(l_data);
        for(rty_cnt = 0; rty_cnt <= 25; rty_cnt++){
            if(rty_cnt > 0) LED_RETRY = _HIGH;
            read_data = ROM_write(a.hl_address[1], a.hl_address[0], write_data);
            lcd.locate(0,1);
            lcd.printf("%04X  %02X %02X   %2D", a.address, write_data, read_data, rty_cnt);
            if(read_data == write_data) goto __NEXT_ADDRS;
        }
        goto __RTY_ERROR;        
 
 __NEXT_ADDRS:    
    }
    lcd.locate(0,0);
    lcd.printf("Success!        ");
    return;

__RTY_ERROR:
    lcd.locate(0,1);
    lcd.printf("Retry Error");
    return;
        
__IN_FILE_OPEN_ERROR:
    lcd.locate(0,1);
    lcd.printf("File Open Error ");
    return;
} //copy_rom

void init(){
    CE = _HIGH;
    OE = _HIGH;
    RD = _HIGH;
    WR = _HIGH;
    SET_WRITE;
    DATA = 0;
    ADRS = 0;
    
    Vcc_0V_Vpp_0V();
        
    LED_BUSY = _LOW;
    LED_5V = _LOW;
    LED_12V = _LOW;
    LED_RETRY = _LOW;
    
    RESET = _LOW;
    RESET = _HIGH;
    wait_us(100);
    RESET = _LOW;
} //init()

int main() {

    init();
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("EPROM Writter   ");
    lcd.locate(0,1);
    lcd.printf("MAX ADRS: %5d ", MAX_ADDRESS);
    wait(3);
    while(1){
        switch(SW) {
            case(0):
                blank_check();
                break;
            case(1):
                write_rom();
                fclose( fp );
                break;
            case(2):
                read_rom();
                fclose( fp );
                break;
            case(3):
                copy_rom();
                fclose( fp );                
                break;                  
            default:
                break;
        } //switch(SW)
        Vcc_0V_Vpp_0V();
        wait(5);
    } //while(1)
} //main()
