/* This is a thermometer using DS1820. With DS1820 library 
of Michael Hagberg, I just used most of the sample cords.
Please see notebook [http://mbed.org/users/jf1vrr/notebook/ds1820-thermometer/].
*/
#include "mbed.h"
#include "TextLCD.h"
#include "DS1820.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

const int MAX_PROBES = 1;
DS1820* probe[MAX_PROBES];

int main() {
    int i;
    int devices_found=0;
    // Initialize the probe array to DS1820 objects
     for (i = 0; i < MAX_PROBES; i++)
        probe[i] = new DS1820(p19);
    // Initialize global state variables
    probe[0]->search_ROM_setup();
    // Loop to find all devices on the data line
    while (probe[devices_found]->search_ROM() and devices_found<MAX_PROBES-1)
        devices_found++;
    // If maximum number of probes are found, 
    // bump the counter to include the last array entry
    if (probe[devices_found]->ROM[0] != 0xFF)
        devices_found++;

    lcd.cls();
    if (devices_found==0)
        lcd.printf("No devices found");
    else {
        lcd.printf("DS1820 Thermo" );
        while (true) {
            probe[0]->convert_temperature(DS1820::all_devices);
            lcd.locate(0,1);
            for (i=0; i<devices_found; i++) {
                lcd.printf("%4.1fc",probe[i]->temperature('c'));
            }
        }
    }
}
