/*FSK with A9834 by MLabo 2011/07/17*/
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); //StarBoard Orenge
DigitalOut FSELECT(p17);
DigitalOut FSYNC(p18);
DigitalOut SCLK(p19);
DigitalOut SDATA(p20);

void serial_out(uint16_t data) {

    FSYNC = 0;
    data & 0x8000? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x4000? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x2000? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x1000? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0800? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0400? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0200? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0100? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0080? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0040? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0020? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0010? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0008? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0004? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0002? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    data & 0x0001? SDATA = 1 : SDATA = 0;SCLK = 0;SCLK = 1;
    FSYNC = 1;
}

int main() {
float SetFreq;
uint32_t temp, freqdata;
uint16_t Uptemp, Lowtemp;
char l[63];

    SCLK = 1;
    SDATA = 0;
    FSYNC = 1;
    FSELECT = 0;
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("FSK With AD9834");

    l[0] = 0x01; //BLNK
    l[1] = 0x01; //BLNK
    l[2] = 0x01; //BLNK
    l[3] = 0x03; //T
    l[4] = 0x0B; //H
    l[5] = 0x21; //E
    l[6] = 0x09; //SP
    l[7] = 0x3B; //Q
    l[8] = 0x39; //U
    l[9] = 0x19; //I
    l[10] = 0x1D; //C
    l[11] = 0x3D; //K
    l[12] = 0x09; //SP
    l[13] = 0x27; //B
    l[14] = 0x15; //R
    l[15] = 0x07; //O
    l[16] = 0x33; //W
    l[17] = 0x0D; //N
    l[18] = 0x09; //SP
    l[19] = 0x2D; //F
    l[20] = 0x07; //O
    l[21] = 0x2F; //X
    l[22] = 0x09; //SP
    l[23] = 0x35; //J
    l[24] = 0x39; //U
    l[25] = 0x0F; //M
    l[26] = 0x1B; //P
    l[27] = 0x29; //S
    l[28] = 0x09; //SP
    l[29] = 0x07; //O
    l[30] = 0x1F; //V
    l[31] = 0x21; //E
    l[32] = 0x15; //R
    l[33] = 0x09; //SP
    l[34] = 0x03; //T
    l[35] = 0x0B; //H
    l[36] = 0x21; //E
    l[37] = 0x09; //SP
    l[38] = 0x13; //L
    l[39] = 0x31; //A
    l[40] = 0x23; //Z
    l[41] = 0x2B; //Y
    l[42] = 0x09; //SP
    l[43] = 0x25; //D
    l[44] = 0x07; //O
    l[45] = 0x17; //G
    l[46] = 0x37; //Figures
    l[47] = 0x0F; //.
    l[48] = 0x09; //SP
    l[49] = 0x37; //Figures
    l[50] = 0x3B; //1
    l[51] = 0x33; //2
    l[52] = 0x21; //3
    l[53] = 0x15; //4
    l[54] = 0x03; //5
    l[55] = 0x2B; //6
    l[56] = 0x39; //7
    l[57] = 0x19; //8
    l[58] = 0x07; //9
    l[59] = 0x1B; //0
    l[60] = 0x05; //CR
    l[61] = 0x11; //LF
    l[62] = 0x3F; //Letter

    freqdata = 7030000; //Space
    SetFreq = 5.592405 * (uint32_t)freqdata;
    temp = (uint32_t)SetFreq;
    Lowtemp = (uint16_t)(temp & 0x3FFF);
    Uptemp = (uint16_t)((temp/16384) & 0x3FFF);    
    serial_out(0x2228);
    serial_out(Lowtemp + 0x4000);
    serial_out(Uptemp + 0x4000);

    freqdata = 7030170; //Mark
    SetFreq = 5.592405 * (uint32_t)freqdata;
    temp = (uint32_t)SetFreq;
    Lowtemp = (uint16_t)(temp & 0x3FFF);
    Uptemp = (uint16_t)((temp/16384) & 0x3FFF); 
    serial_out(0x2A28);
    serial_out(Lowtemp + 0x8000);
    serial_out(Uptemp + 0x8000);

    while(1){
        for(int i = 0; i < 64; i++){
            for(int j = 0; j < 7; j++){
                if((l[i] << j + 1) & 0x80) FSELECT = 1; else FSELECT = 0;
                if(j != 6) wait_ms(22); else wait_ms(33);
            }
        } 
        wait_ms(1000);       
    }    
}