/*AD9834 DDS Test 2011/07/14 MLabo*/
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30); //Starboard Orenge
DigitalOut FSYNC(p18);
DigitalOut SCLK(p19);
DigitalOut SDATA(p20);

Timer timer;

void serial_out(uint16_t data) {

    FSYNC = 0;
    data & 0x8000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x4000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x2000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x1000? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0800? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0400? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0200? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0100? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0080? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0040? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0020? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0010? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0008? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0004? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0002? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    data & 0x0001? SDATA = 1 : SDATA = 0; SCLK = 0; SCLK = 1;
    FSYNC = 1;
}

int main() {
    float SetFreq;
    uint32_t temp, freqdata;
    uint16_t Uptemp, Lowtemp;
    int begin, end;

    SCLK = 1;
    SDATA = 0;
    FSYNC = 1;

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("AD9834 test" );

    timer.start();
    begin = timer.read_us();
    for ( freqdata = 0; freqdata < 16000000; freqdata++) {

        SetFreq = 5.592405 * (uint32_t)freqdata;
        temp = (uint32_t)SetFreq;
        Lowtemp = (uint16_t)(temp & 0x3FFF);
        Uptemp = (uint16_t)((temp/16384) & 0x3FFF);
        serial_out(0x2028);
        serial_out(Lowtemp + 0x4000);
        serial_out(Uptemp + 0x4000);
    }
    end = timer.read_us();
    lcd.locate(0,1);
    lcd.printf("%duS", end - begin);
    while (1) {}

}
