/*******************************************************************************
* This program demonstrates the use of structures                              *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 25/11/2013 First issue of code                                          *
*******************************************************************************/

#include "mbed.h"
#include "USBSerial.h"

USBSerial serial; // Virtual serial port over USB. Use Teraterm as the interface

struct coordXY { int iX; int iY; }; // Define a new structure

int main() {
   coordXY Position1, Position2;      // Declare variables with the new structure
   
   wait (10);             // Wait 10 seconds to connect port

   Position1.iX = 1;      // Sets Position1.iX only
   Position1.iY = 2;      // Sets Position1.iY only
   Position2.iX = 9;      // Sets Position2.iX only
   Position2.iY = 6;      // Sets Position2.iY only

   serial.printf("Position1.iX:%i, Position1.iY:%i\n\r", Position1.iX, Position1.iY);

   Position1 = Position2; // Directly load Position1 from Position2
   serial.printf("Position1.iX:%i, Position1.iY:%i\n\r", Position1.iX, Position1.iY);

   for(;;) {}             // Loop forever
}