/*******************************************************************************
* RenBED two seven segment display driver                                      *
* Copyright (c) 2013 Jon Fuge                                                  *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* SevenSegmentDisplay.h                                                        *
*                                                                              *
* V1.0 23/12/2013 First issue of code                      Jon Fuge            *
* V1.1 15/01/2014 Added code to display integers           Jon Fuge            *
*******************************************************************************/

#ifndef _SEVENSEGMENTDISPLAY_H
#define _SEVENSEGMENTDISPLAY_H

#include "mbed.h"

class SevenSegmentDisplay {
public:

#define INSTANT     0
#define FADE        1
#define FLASH       2

    SevenSegmentDisplay(uint8_t ui8Fade);
    void DisplayDigits(uint8_t ui8LeftDigit, uint8_t ui8RightDigit);
    void DisplayInt(int iValue);
    void FadeMode(uint8_t ui8Fade);
    void FlashRate(uint16_t ui16FlashRateMs);
    void FadeRate(uint8_t ui16FadeRateMs);

private:
#define RIGHT_DIGIT    1
#define LEFT_DIGIT     0
    uint8_t D_ui8Mux;                   // multiplexor set       0:Right digit    1:Left digit
    uint8_t D_ui8Common;                // common On level set   0:Anode common   1:Cathode common
    uint8_t D_ui8LeftDigit;
    uint8_t D_ui8RightDigit;
    uint8_t D_ui8Mode;                  // Counter for FadeFlag
    uint16_t D_ui16FlashRatems;         // Flash rate in ms
    uint8_t D_FadeRatems;               // Fade rate in ms
    uint8_t D_ui8SegmentDrives[2][8];   // Counters for Segment drives

    volatile int     iDisplayValue;     // Storage for integer to be displayed
    volatile int     iSequence;         // Sequence for integer to be displayed
    
    DigitalOut mux;
    DigitalOut seg_a;
    DigitalOut seg_b;
    DigitalOut seg_c;
    DigitalOut seg_d;
    DigitalOut seg_e;
    DigitalOut seg_f;
    DigitalOut seg_g;
    DigitalOut seg_p;
    Ticker timer;
    Ticker inttimer;

    void SevenSegmentDisplayMux(void);
    void SevenSegmentIntMux(void);
    void SegmentDrive(uint8_t ui8Value, uint8_t ui8Mux);


};

#endif    // _SEVENSEGMENTDISPLAY_H