/* mbed Seven segment LED (Maximum four digit) Library
 * Copyright (c) 2011 suupen
 * 120422 hyoji no smooth to hard no settei wo kirike suru kansuu wo tuika. 
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


//***********************************************************************/
//*                                                                     */
//*    ledDynamic.h                                                     */
//* V1.0 : 4digit(4com) display                                         */
//* V2.0 : 8digit(8com) display                                         */
//*                                                                     */
//***********************************************************************/
#ifndef _SEVENSEGLED_H
#define _SEVENSEGLED_H

/** Seven segment Numeric LED control class
 *
 * Example:
 * @code
 * //-----------------------------------------------------------------------------
 * //sevenSegmentLed Library Example
 * //
 * //This program by one every second counts, do a 8-digit seven-segment LED display.
 * //
 * //seven segment numeric LED Display : LTC4627P
 * //      http://www.excesssolutions.com/mas_assets/acrobat/ES5721.pdf
 * //
 * // LTC4627T                              Resister        mbed
 * // Pin No     Function                   [ohm]           Function
 * // ---------------------------------------------------------------------------
 * //  1         Common Anode Digit 1        -              P29 
 * //  2         Common Anode Digit 2        -              P13
 * //  3         Cathode D                   200            P22
 * //  4         Common Anode L1,L2,L3       -              -
 * //  5         Cathode E                   200            P24
 * //  6         Common Anode Digit 3        -              P25  
 * //  7         Cathode D.p.                200            P30
 * //  8         Common Anode Digit 4        -              P27 
 * //  9         No Connection               -              -
 * // 10         No Pin                      -              -
 * // 11         Cathode F                   200            P16 
 * // 12         No Pin                      -              -
 * // 13         Cathode C,L3                200            P17 
 * // 14         Cathode A,L1                200            P14
 * // 15         Cathode G                   200            P19
 * // 16         Cathode B,L2                200            P20
 * //---------------------------------------------------------------------------
 * #include "mbed.h" 
 * #include "SevenSegLed.h"
 *
 * //                     common type (0:anode common 1:cathode common)
 * //                     | 
 * //                     |  display mode (0:smooth 1:hard)
 * //                     |  |
 * //                     |  |    segA segB segC segD segE segF segG segP com1 com2 com3 com4 (com5,com6,com7,com8 = NC)                          
 * //                     |  |    |    |    |    |    |    |    |    |    |    |    |    | 
 * SevenSegLed segmentled(0, 0, p14, p20, p17, p22, p24, p16, p19, p30, p29, p13, p25, p27);
 *
 *
 * //                   1  2  3  4digit 
 * //                   |  |  |  |
 * uint8_t D_7seg[4] = {0, 0, 0, 0}; // seven segment digit number    (0x00:"0", 0x01:"1", ... , 0x09:"9", 0x0A:"A", ... , 0x0F:"F", other:" ")
 * uint8_t D_dot[4]  = {0, 0, 0, 0}; // seven segment digit dotpoint. (0:off 1:on)
 * 
 * 
 * Timer timer;    // 1second timer
 *     
 * int main() {
 *     uint16_t counter = 0;
 *     
 *     timer.start();
 * 
 *     while(1) {
 *         // After one second to start the process
 *         if(timer.read_ms() >= 1000){
 *             timer.reset();
 *             counter++;
 * 
 *             // Display digit data updates
 *             D_7seg[0] = (uint8_t)((counter & 0xF000) >> 12);
 *             D_7seg[1] = (uint8_t)((counter & 0x0F00) >> 8);
 *             D_7seg[2] = (uint8_t)((counter & 0x00F0) >> 4);
 *             D_7seg[3] = (uint8_t)(counter & 0x000F);
 *             
 *             // Display dot point data updates
 *             D_dot[0] = 0;
 *             D_dot[1] = 0;
 *             D_dot[2] = 0;
 *             D_dot[3] = 0;            
 *             
 *             // dot point data set
 *             D_dot[counter & 0x0003] = 1;
 *         }
 * 
 *         // seven segment display to output data
 *         // This function, please repeat the process in less than 1ms.
 *         segmentled.SevenSegLed_main(D_7seg, D_dot);      
 *  
 *     }
 * }
 * @endcode
 */



#include "types.h"

class SevenSegLed {
public:

    //@SS120422 
    /** Display henko set
    * @param smooth 0:smooth  1:hard
    */
    void smoothSet(uint8_t smooth);

    /** Create a seven segment led array object connected to the specified DigitalOut pin
    * @param commonPole The polarity of the seven segment led common  0:Anode common, 1:Cathode common
    * @param smooth Reading the LED display method.  0:Smooth changing the LED display in one second  1:Quickly changing the LED display
    * @param seg_a - seg_p DigitalOut pin to connect to.    To provide members with an array of uint8_t digit minutes.
    * @param com_1 - com_8 DigitalOut pin to connect to.    To provide members with an array of uint8_t digit minutes. 8 digits maximum   
    */
    SevenSegLed(uint8_t commonPole, uint8_t smooth, PinName seg_a, PinName seg_b, PinName seg_c, PinName seg_d, PinName seg_e, PinName seg_f, PinName seg_g, PinName seg_p,
                PinName com_1 = NC, PinName com_2 = NC, PinName com_3 = NC, PinName com_4 = NC,
                PinName com_5 = NC, PinName com_6 = NC, PinName com_7 = NC, PinName com_8 = NC);
    
    /** Data set to the seven segment LED display
    * @param number Array variable address pointer of Numerical data 0 - 9,A - F : The figures show, 0x10:off
    * @param dot    Array variable address pointer of dot data  0:off 1:on
    */
    void SevenSegLed_main(uint8_t* number, uint8_t* dot);

private:
void segmentGrayDataKosin(void);
void comAllClear(void);
void segAllClear(void);
void segDataSet(uint8_t keta);
void output(void);

//  pin set_seg, _com;
    DigitalOut _seg_a, _seg_b, _seg_c, _seg_d, _seg_e, _seg_f, _seg_g, _seg_p;
    DigitalOut _com_1, _com_2, _com_3, _com_4, _com_5, _com_6, _com_7, _com_8;
    
    Ticker timer;

#define Z_ketaSuu (8)   // 7segment no keta suu
#define Z_segSuu  (8)   // 7segmetn no segment suu (a,b,...,g,Dp)
#define Z_grayMax (100)  // grayData max 100 kaicho
#define Z_pwmGrayMax (100) // pwm max (led heno pwm syuturyoku no max)

 
uint8_t D_7seg[Z_ketaSuu];    // digit number display request 0:"0", 1:"1", ... , 9:"9", A:"A", B:"b", C:"C", D:"d", E:"E", F:"F"
                            // [0]:digit1, [1]:digit2, ... ,[7]:digit8
uint8_t D_dot[Z_ketaSuu];   // digit dot display request   0:off  1(not 0):on
                            // [0]:digit1, [1]:digit2, ... ,[7]:digit8
                            

uint8_t D_7segGray[Z_ketaSuu][Z_segSuu];    // hyoji segment no gray data 0:syoto 1:min - 10:max

uint8_t DT_pwmGray[Z_grayMax + 1];  // gray data kara pwm data heno henkan table

uint8_t D_comNull;  // comX Null check No set (0:all com is NC 1:com1 connect, 2:com2 connect,...,8:com8 connect(all com connect)

uint8_t D_smooth; // Those who will be reading the LED display  0:smooth 1:hard
#define Z_smooth (0)
#define Z_hard   (1)

uint8_t D_commonOn; // common On level set   0:Anode common   1:Cathode common
uint8_t D_commonOff;

uint8_t D_segmentOn; // segment On level set 0:Cathode common 1:Anode common
uint8_t D_segmentOff;
};

#endif    // _SEVENSEGLED_H
