/*******************************************************************************
* This program demonstrates how to drive the seven segment display             *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 24/12/2013 First issue of code                                          *
*******************************************************************************/

#include "mbed.h"
#include "SevenSegmentDisplay.h"
#include "MotorController.h"

uint16_t u16LeftSpeed = 0, u16RightSpeed = 0;

// Options to instantiate SevenSegmentDisplay are...
// FADE: causes the number changes to fade in smoothly
// INSTANT: causes the an instant number change
// + FLASH: causes the display to flash
SevenSegmentDisplay segmentled( FADE );

MotorController RenBuggy(p5, p7, p9, p6, p8, p10);
DigitalIn LFast(p9), LSlow(p12), RFast(p15), RSlow(p18);

void attimeout();            //declare prototype for timeout handler.

Ticker timeout;             //Create an instance of class Ticker called timeout.

int main()
{
    LFast.mode(PullUp);
    LSlow.mode(PullUp);
    RFast.mode(PullUp);
    RSlow.mode(PullUp);

    timeout.attach(&attimeout, 3);
//    LeftMotor.SetMotorPwmAndRevolutions(18000,32);

    RenBuggy.Forwards(100);

    for(;;) {
    } // Loop forever (the program uses interrupts)
}

void attimeout()
{
    static int Flip = 0;

    if (Flip++ == 0)
        segmentled.DisplayInt(RenBuggy.ReadLeftOdometer());
    else
    {
        segmentled.DisplayInt(RenBuggy.ReadRightOdometer());
        Flip = 0;
    }
}