/*******************************************************************************
* Used to drive RenBed with a reaction timer game                              *
* Copyright (c) 2014 Renishaw plc                                              *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* RenBed_Reaction_Timer                                                        *
*                                                                              *
* V1.0 8/5/2014                                           Jon Fuge             *
*******************************************************************************/

#include "mbed.h"
#include "SevenSegmentDisplay.h"

SevenSegmentDisplay segmentled( FADE ); // Configure display to fade numbers in

DigitalOut myled(P1_14);    // Define an output pin for the LED
DigitalIn  mybutton(P0_9);  // We use DebounceIn for mechanical switches

void Counter();             // Define our counter function
Ticker timeout;             //Create an instance of class Ticker called timeout.

int iCount;                 // Variable to store counter

int main() {

    mybutton.mode(PullUp);                     // Set switch input to pull-up mode
    segmentled.DisplayDigits(36,36);           // Turn display off

    while (mybutton == 0) {}                   // Wait for button change
    wait(5);                                   // wait for five seconds before starting game
    myled = 1;                                 // Turn the LED on
    segmentled.DisplayDigits(16,24);           // Display Go
    timeout.attach_us(&Counter, 10000);        // Set up a 10ms counter for Hundreths of a second
    
    while ((mybutton == 1) && (iCount <99)) {} // Wait for button change
    
    timeout.detach();                          // Stop the timer
    
    segmentled.DisplayInt(iCount);             // Display reaction time.
    myled = 0;                                 // Turn the LED off
    while (1) {};
}

void Counter()
{
    iCount = iCount + 1;                       // Count hundreths of a second
}