/*******************************************************************************
* This program demonstrates how to drive the seven segment display             *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 10/2/2014 First issue of code                                          *
*******************************************************************************/

#include "mbed.h"
#include "SevenSegmentDisplay.h"

// Options to instantiate SevenSegmentDisplay are...
// FADE: causes the number changes to fade in smoothly
// INSTANT: causes the an instant number change
// + FLASH: causes the display to flash
SevenSegmentDisplay segmentled( FADE );

DigitalOut myled(P0_21);

void Counter();
Ticker timeout;             //Create an instance of class Ticker called timeout.

int main() {
    timeout.attach(&Counter, 1);

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void Counter()
{
    static int Count = 0;

    segmentled.DisplayInt(Count);
    Count = Count + 1;
    if (Count == 100)
        Count = 0;
}