//***************************************************************************//
//This tutorial shows how to read a switch and toggle a LED.
//Connect the Anode of the LED to DIP36 (P0_21), the Anode of the resistor
//connects through a 390 Ohm resistor to DIP1 (0V).
//Connect the switch between DIP5 (P0_9) and DIP1 (0V). 
//
//Jon Fuge
//12/11/2013
//***************************************************************************//
#include "mbed.h"            //Include the mbed header file which contains the prototypes of the libraries used here (DigitalOut) as well as various syntax definitions.

DigitalIn mybutton(P0_9);    //Creates an instance of DigitalIn called mybuttonwhich reads bit 9 of port 0 (DIP5).
DigitalOut myled(P0_21);     //Creates an instance of DigitalOut called myled which controls bit 21 of port 0 (DIP36).
int main() {
    mybutton.mode(PullUp); // Configure pin to have a pull-up input
    while(1) {               //Create infinite loop to keep program running.
        if (mybutton == 0) { //mybutton has been pressed 0 indicates input is at 0V, a 1 would mean the input is 3.3V.
            myled = !myled;  //myled will now become !myled (! means NOT).
        }
        wait(0.2);           //Wait for 0.2 seconds to "debounce" the switch.
    }                        //Loop to the start.
}
