/*******************************************************************************
* This program demonstrates the use of pointers                                *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 25/11/2013 First issue of code                                          *
*******************************************************************************/

#include "mbed.h"
#include "USBSerial.h"

USBSerial serial; // Virtual serial port over USB. Use Teraterm as the interface

int main() {
   char cBox1 = 5;
   char cBox2 = 10;     // Declare two variables.
   char *ptr  = &cBox1; // Declare a pointer directed to cBox1
   
   wait (10);           // Wait 10 seconds to connect port

   serial.printf("cBox1:%i, cBox2:%i, *ptr:%i\n\r", cBox1, cBox2, *ptr);

   cBox2 = cBox1;       // cBox2 was 10, but is now 5
   serial.printf("cBox1:%i, cBox2:%i, *ptr:%i\n\r", cBox1, cBox2, *ptr);
   
   cBox1 = 15;          // cBox1 was 5, but is now 15
   serial.printf("cBox1:%i, cBox2:%i, *ptr:%i\n\r", cBox1, cBox2, *ptr);
   // cBox2 will still report 5, but *ptr now reports 15

   for(;;) {}           // Loop forever
}