/*******************************************************************************
* This program demonstrates determines if a number is odd or even              *
* Jon Fuge V1.0 26/11/2013 First issue of code                                 *
*******************************************************************************/
#include "mbed.h"
#include "USBSerial.h"

union byte // Define new type “BYTE”
{
    char Byte; // Use this to map a byte
    struct {
       char Odd:    1; // this is the same as Bit0
       char Others: 7; // Just pad the rest of the bits
    };
};

USBSerial serial; // Virtual serial port over USB. Use Teraterm as the interface

int main() {
   byte cMyNumber;      // Declare variable cMyNumber
   cMyNumber.Byte = 53; // Set it to an odd number

   wait (10); // Wait 10 seconds to connect port
   
   if (cMyNumber.Odd == 1)
      serial.printf("%i is odd\n\r", cMyNumber.Byte);
   else
      serial.printf("%i is even\n\r", cMyNumber.Byte);

   for(;;) {} // Loop forever
}