#include "mbed.h"

DigitalOut myled(P0_21); // Define an output

union BYTE // Define new type “BYTE”
{
    char Byte; // Use this to map a byte
    struct {
       char Bit0: 1; // map individual
       char Bit1: 1; // bits onto the
       char Bit2: 1; // mapped byte.
       char Bit3: 1;
       char Bit4: 1;
       char Bit5: 1;
       char Bit6: 1;
       char Bit7: 1;
    } Bits;
};

int main() {
   BYTE cMyNumber; // Declare out counter
   cMyNumber.Byte = 0; // Initialise our counter

    for(;;) { // Loop forever
        wait(0.5); // Wait half a second
        cMyNumber.Byte++; // Increment counter
        myled = cMyNumber.Bits.Bit0; // Indicate odd value
    }
}
