/*******************************************************************************
* RenBED DC Motor Drive for RenBuggy                                           *
* Copyright (c) 2014 Jon Fuge                                                  *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* DCMotorDrive.h                                                               *
*                                                                              *
* V1.0 06/01/2014 First issue of code                      Jon Fuge            *
*******************************************************************************/

#ifndef _DCMOTORCONTROLLER_H
#define _DCMOTORCONTROLLER_H

#include "mbed.h"
#include "DCMotorDrive.h"

#define WHEEL_CIRCUMFERENCE 114.4
#define COUNTS_PER_ROTATION 64
#define PWM_SPEED_ADJUST 20
#define ROTATION_LIMIT 20

class MotorController
{
public:
    MotorController(PinName LMotorOut, PinName LBrakeOut, PinName LSensorIn, PinName LMotorOut, PinName RBrakeOut, PinName LSensorIn);
    void    Forwards(int ForwardCount);
    void    ResetOdometer(void);
    int     ReadOdometer(void);
    int     ReadLeftOdometer(void);
    int     ReadRightOdometer(void);
private:
    DCMotorDrive    _LeftMotor;
    DCMotorDrive    _RightMotor;
    int             LeftMotorSpeed;
    int             RightMotorSpeed;
    int             LeftToRightRatio;
    int             DistanceToTravel;
    Ticker          trackomatic;
    
    void    MatchSpeeds(void);
    void    UpdatePwms(void);
};

#endif    // _DCMOTORCONTROLLER_H