/*******************************************************************************
* RenBED DC Motor Drive for RenBuggy                                           *
* Copyright (c) 2014 Jon Fuge                                                  *
*                                                                              *
* Permission is hereby granted, free of charge, to any person obtaining a copy *
* of this software and associated documentation files (the "Software"), to deal*
* in the Software without restriction, including without limitation the rights *
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell    *
* copies of the Software, and to permit persons to whom the Software is        *
* furnished to do so, subject to the following conditions:                     *
*                                                                              *
* The above copyright notice and this permission notice shall be included in   *
* all copies or substantial portions of the Software.                          *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR   *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,     *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE  *
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER       *
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,*
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN    *
* THE SOFTWARE.                                                                *
*                                                                              *
* DCMotorDrive.h                                                               *
*                                                                              *
* V1.0 06/01/2014 First issue of code                      Jon Fuge            *
*******************************************************************************/

#ifndef _DCMOTORDRIVE_H
#define _DCMOTORDRIVE_H

#include "mbed.h"

#define PWM_PERIOD 20
#define MOTOR_STALL_TIME 2

class DCMotorDrive
{
public:
    DCMotorDrive(PinName MotorOut, PinName BrakeOut, PinName SensorIn);
    void    SetMotorPwm(int PwmValue);
    void    SetMotorPwmAndRevolutions(int PwmValue, int MaxRevolutions);
    int     GetAveragePulseTime(void);
    int     GetLastPulseTime(void);
    int     GetRevolutionsLeft(void);
    void    ResetOdometer(void);
    int     ReadOdometer(void);
    int     ReadCaptureTime(void);

private:
    Ticker          timeout;
    Timer           PulseClock;
    volatile int    ClockPointer;
    volatile int    LastPulseTime;
    volatile int    RotationCounter;
    volatile int    RevolutionLimit;

    PwmOut          _MotorPin;
    DigitalOut      _BrakePin;
    InterruptIn     _SensorIn;
    
    void    Counter(void);
    void    Stall(void);
};

#endif    // _DCMOTORDRIVE_H