#include "mbed.h"           //Include the mbed header file which contains the prototypes of the libraries used here (DigitalOut, Ticker) as well as various syntax definitions.
#include "SevenSegLed.h"    //Include the SevenSegLed header file which contains the class for the SevenSegLed output library.

// Lets define some "macros" to make the code easier to read

#define mUnits D_7seg[1]     // When the compiler finds "units" it will substiute it for "D_7seg[1]"
#define mTens  D_7seg[0]     // When the compiler finds "units" it will substiute it for "D_7seg[1]"
#define mDot   D_dot[1]      // When the compiler finds "units" it will substiute it for "D_7seg[1]"

void attimeout();            //prototype declared above main function to avoid errors.

//Below is the creation of an instance of SevenSegLed called segmentled.
//It is constructed with the information relating to the pins which are used, the type of display (common anode or cathode) and
//the type of transition between outputs. Display mode = smooth will fade the new number in while hard will just change it immediately.
//com1 and com2 are the pins which power each display. As we only use one pin, com1 is filled with any unused pin and com2 is filled with
//the pin that is used for MUX. As com2 will go low when not in use the other display will be selected and the MUX effect will still work.
//
//                     common type (0:anode common 1:cathode common)
//                     |
//                     |  display mode (0:smooth 1:hard)
//                     |  |
//                     |  |   segA   segB   segC   segD   segE   segF   segG   segP  com1  com2
//                     |  |    |      |      |      |      |      |      |      |     |     |
SevenSegLed segmentled(0, 0, P1_23, P1_28, P0_16, P1_31, P1_13, P1_16, P1_19, P0_23, p21, P1_25);

//Define two arrays to house the data to be outputted. D_7seg can contain digits 0-F and D_dot 0-1.
//
//                   0  1   //0 = leftmost digit, 1 = rightmost digit
//                   |  |
uint8_t D_7seg[2] = {0, 0}; // seven segment digit number    (0x00:"0", 0x01:"1", ... , 0x09:"9", 0x0A:"A", ... , 0x0F:"F", other:" ")
uint8_t D_dot[2]  = {0, 0}; // seven segment digit dotpoint. (0:off 1:on)

Ticker timeout;             //Create an instance of class Ticker called timeout.

int main()
{

    timeout.attach_us(&attimeout, 500000);            //Call attach function in timeout instance to call attimeout() every 500,000us (half a second).

    for(;;) {
        segmentled.SevenSegLed_main(D_7seg, D_dot);   //Repeatedly call the Segment output function to keep the displays multiplexed.
    }
}

void attimeout()                //Timer interrupt routine.
{
    mDot = 1 - mDot;
    if (mDot == 1) {
        mUnits++;               // This means the same as D_7seg[0] = D_7seg[0] + 1; Increment "units" digit
        if (mUnits > 9) {       // "units" digit should be in the range 0 -> 9
            mUnits = 0;         // Reset the "units" to 0
            mTens++;            // Increment "tens" digit
            if (mTens > 9) {    // "tens" digit should be in the range 0 -> 9
                mTens = 0;      // Reset the "tens" to 0
            }
        }
    }
}
