/*******************************************************************************
* This program demonstrates the use of constants, variables and arrays         *
*                                                                              *
* Jon Fuge                                                                     *
* V1.0 25/11/2013 First issue of code                                          *
*******************************************************************************/

#include "mbed.h"
#include "USBSerial.h"

USBSerial serial; // Virtual serial port over USB. Use Teraterm as the interface

const float fPI = 3.1415927; // Declare a value for PI
const char cDIAMETER[4] = {15,18,14,17}; // constant array of circle diameters

char cMatrix[2][3] = {{2,3,5},{7,11,13}}; // matrix array of circle diameters
int main() {
   float fCircumference; // Declare local variables
   wait (10); // Wait 10 seconds to connect port

   // Calculate circumference then send the result to the USB serial port.
   fCircumference = fPI * 16; // Magic numbers should be avoided!
   serial.printf("Diameter:%i Circumference:%f\n\r", 16, fCircumference);
   fCircumference = fPI * (float)cDIAMETER[2]; // accessing an array.
   serial.printf("Diameter:%i Circumference:%f\n\r", cDIAMETER[2], fCircumference);
   fCircumference = fPI * (float)cMatrix[0][1]; // accessing an array.
   serial.printf("Diameter:%i Circumference:%f\n\r", cMatrix[0][1], fCircumference);

   for(;;) {} // Loop forever
}