/* mbed Example Program
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)


//Ticker flipper;
//DigitalOut led1(LED1);
//DigitalOut led2(LED2);
//AnalogIn   ain(A0);

//Timer t;
//float duration = 0;
// Configuration for sinewave output
#define BUFFER_SIZE (360)
float buffer_triang[BUFFER_SIZE]={};
float buffer_sine[BUFFER_SIZE]={};
float buffer_out0[BUFFER_SIZE]={};
float buffer_out1[BUFFER_SIZE]={};
//int K = 0;

void calculate_sinewave(void);
void calculate_triangwave(void);
void calculate_out(void);
// Create the sinewave buffer

void calculate_sinewave(void){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer_sine[i] = (float)( ( (cos(rads + PHASE))));
  }
}

// Create the triangular buffer
void calculate_triangwave(void)
{
    for (int k = 1; k < 100; k++) {
        for (int i = 0; i < BUFFER_SIZE; i++) {
            double rads = (PI * i)/180.0; // Convert degree in radian
            buffer_triang[i] = (float)( (8/(PI*PI)) *sin(PI*k/2) *(sin(k*rads*10)/(k*k)) + buffer_triang[i]);
        }
    }
}
// Create the comparação buffer
void calculate_out(void)
{
    for (int k = 1; k < 100; k++) {
        for (int i = 0; i < BUFFER_SIZE; i++) {
            buffer_out0[i] = buffer_triang[i]>buffer_sine[i] ;
        }
    }
}


    int main() {
        printf("Sinewave example\n");
        calculate_sinewave();
        calculate_triangwave();
        calculate_out();
        
        while(1) {
            //led2 = !led2;
            // sinewave output
            for (int i = 0; i < BUFFER_SIZE; i++) {
                printf("%f, %f, %f \n", buffer_triang[i]*1.0f,buffer_sine[i]*1.0f,buffer_out0[i]*1.0f);
                wait(0.001);
            }
            //printf("__________________________________\n");
            //printf("The time taken was %f s \n", duration);
            //wait(0.2);
        }
    }
