/*Code by Jesse Kaiser, s1355783 for control of the 2DOF Planar Table
Some variables are also numbered at the end. The numbers stands for the muscle that controls it.
Biceps =            1
Triceps =           2
Pectoralis Major =  3
Deltoid =           4
The "x" and "y" at the end of variables stand for the X-Spindle or Y-Spindle respectivly.
*/

#include "mbed.h"
#include "C12832_lcd.h"
#include "arm_math.h"
//#include "HIDScope.h"

#define P_Gain      0.99
#define K_Gain      150   //Gain of the filtered EMG signal
#define Damp        5    //Deceleration of the motor
#define Mass        1    // Mass value
#define dt          0.01 //Sample frequency
#define MAX_bi      0.40 //Can be used for normalisation of the EMG signal of the biceps
#define MAX_tri     0.60
#define MAX_pect    0.48
#define MAX_delt    1.07
#define EMG_tresh1   0.01
#define EMG_tresh2   0.01
#define EMG_tresh3   0.01
#define EMG_tresh4   0.01
#define H_Gain  5
#define Pt_x    0.80
#define Pt_y    0.50
#define error_tresh 0.02

//Motor control
DigitalOut Dirx(p25);
PwmOut Stepx(p26);
DigitalOut Diry(p23);
PwmOut Stepy(p28);

//Signal to and from computer
Serial pc(USBTX, USBRX);

//Position sensors
AnalogIn Posx(p20);
AnalogIn Posy(p19);
DigitalOut Enablex(p27);
DigitalOut Enabley(p39);

//Microstepping
DigitalOut MS1(p29);
DigitalOut MS2(p30);
DigitalOut MS3(p31);

//EMG inputs
AnalogIn emg1(p15); //EMG bordje bovenop, biceps
AnalogIn emg2(p16); //triceps
AnalogIn emg3(p17);
AnalogIn emg4(p18);

//HIDScope scope(4);
//Ticker   scopeTimer;

//lcd
C12832_LCD lcd;

//Variables for motor control
float setpoint = 1750; //Frequentie setpoint
float step_freq1 = 1;
float step_freq2 = 1;


//EMG filter
arm_biquad_casd_df1_inst_f32 lowpass_biceps;
arm_biquad_casd_df1_inst_f32 lowpass_triceps;
arm_biquad_casd_df1_inst_f32 lowpass_pect;
arm_biquad_casd_df1_inst_f32 lowpass_deltoid;
//lowpass filter settings: Fc = 2 Hz, Fs = 500 Hz, Gain = -3 dB
float lowpass_const[] = {0.00015514839749793376, 0.00031029679499586753, 0.00015514839749793376, 1.9644602512795832, -0.9650808448695751};
arm_biquad_casd_df1_inst_f32 highnotch_biceps;
arm_biquad_casd_df1_inst_f32 highnotch_triceps;
arm_biquad_casd_df1_inst_f32 highnotch_pect;
arm_biquad_casd_df1_inst_f32 highnotch_deltoid;
//highpass filter settings: Fc = 20 Hz, Fs = 500 Hz, notch Fc = 50, Fs = 500 Hz
float highnotch_const[] = {0.8370879899975344, -1.6741759799950688, 0.8370879899975344, 1.6474576182593796, -0.7008943417307579, 0.7063988100714527, -1.1429772843080923, 0.7063988100714527, 1.1429772843080923, -0.41279762014290533};

//state values
float lowpass_biceps_states[4];
float highnotch_biceps_states[8];
float lowpass_triceps_states[4];
float highnotch_triceps_states[8];
float lowpass_pect_states[4];
float highnotch_pect_states[8];
float lowpass_deltoid_states[4];
float highnotch_deltoid_states[8];

//global variabels
float filtered_biceps, filtered_triceps, filtered_pect, filtered_deltoid;
float speed_old1, speed_old2, speed_old3, speed_old4;
float acc1, acc2, acc3, acc4;
float force1, force2, force3, force4;
float speed1, speed2, speed3, speed4;
float damping1, damping2, damping3, damping4;
float emg_x, emg_y;
float cx = 0;
float cy = 0;
float errorx = 0.2;
float errory = 0.2;
float Ps_x = 0;
float Ps_y = 0;
float hstep_freqx = 1;
float hstep_freqy = 1;
float emg_y_abs = 0;
float emg_x_abs = 0;

void looper_emg()
{
    float emg_value1_f32, emg_value2_f32, emg_value3_f32, emg_value4_f32;
    emg_value1_f32 = emg1.read();
    emg_value2_f32 = emg2.read();
    emg_value3_f32 = emg3.read();
    emg_value4_f32 = emg4.read();

    //process emg biceps
    arm_biquad_cascade_df1_f32(&highnotch_biceps, &emg_value1_f32, &filtered_biceps, 1 );   //High pass and notch filter
    filtered_biceps = fabs(filtered_biceps);                                                //Rectifier, The Gain is already implemented.
    arm_biquad_cascade_df1_f32(&lowpass_biceps, &filtered_biceps, &filtered_biceps, 1 );    //low pass filter

    //process emg triceps
    arm_biquad_cascade_df1_f32(&highnotch_triceps, &emg_value2_f32, &filtered_triceps, 1 );
    filtered_triceps = fabs(filtered_triceps);
    arm_biquad_cascade_df1_f32(&lowpass_triceps, &filtered_triceps, &filtered_triceps, 1 );

    //process emg pectoralis major
    arm_biquad_cascade_df1_f32(&highnotch_pect, &emg_value3_f32, &filtered_pect, 1 );
    filtered_pect = fabs(filtered_pect);
    arm_biquad_cascade_df1_f32(&lowpass_pect, &filtered_pect, &filtered_pect, 1 );

    //process emg deltoid
    arm_biquad_cascade_df1_f32(&highnotch_deltoid, &emg_value4_f32, &filtered_deltoid, 1 );
    filtered_deltoid = fabs(filtered_deltoid);
    arm_biquad_cascade_df1_f32(&lowpass_deltoid, &filtered_deltoid, &filtered_deltoid, 1 );

    /*send value to PC.
    scope.set(0,filtered_biceps); //Filtered EMG signal
    scope.set(1,filtered_triceps);
    scope.set(2,filtered_pect);
    scope.set(3,filtered_deltoid);*/
}

/*void looper_motory()
{

    emg_y = (filtered_biceps - filtered_triceps);
    emg_y_abs = fabs(emg_y);
    force1 = emg_y_abs*K_Gain;
    force1 = force1 - damping1;
    acc1 = force1/Mass;
    speed1 = speed_old1 + (acc1 * dt);
    damping1 = speed1 * Damp;
    step_freq1 = setpoint * speed1;
    Stepy.period(1.0/step_freq1);
    speed_old1 = speed1;

    if (emg_y > 0) {
        Diry = 1;
    }

    if (emg_y < 0) {
        Diry = 0;
    }
    //Speed limit
    if (speed1 > 1) {
        speed1 = 1;
        step_freq1 = setpoint;
    }
    //EMG treshold
    if (filtered_biceps < EMG_tresh1 && filtered_triceps < EMG_tresh2) {
        Enabley = 1; //Enable = 1 turns the motor off.
    } else {
        Enabley = 0;
    }

}*/

void looper_motorx()
{

    emg_x = (filtered_pect - filtered_deltoid);
    emg_x_abs = fabs(emg_x);
    force2 = emg_x_abs*K_Gain;
    force2 = force2 - damping2;
    acc2 = force2/Mass;
    speed2 = speed_old2 + (acc2 * dt);
    damping2 = speed2 * Damp;
    step_freq2 = setpoint * speed2;
    Stepx.period(1.0/step_freq2);
    speed_old2 = speed2;

    if (emg_x > 0) {
        Dirx = 1;
    }
    if (emg_x < 0) {
        Dirx = 0;
    }
    //Speed limit
    if (speed2 > 1) {
        speed2 = 1;
        step_freq2 = setpoint;
    }
    //EMG treshold
    if (filtered_pect < EMG_tresh3 && filtered_deltoid < EMG_tresh4) {
        Enablex = 1; //Enable = 1 turns the motor off.
    } else {
        Enablex = 0;
    }

}

int main()
{
    // Attach the HIDScope::send method from the scope object to the timer at 500Hz. Hier wordt de sample freq aangegeven.
    // scopeTimer.attach_us(&scope, &HIDScope::send, 2e3);

    MS1 = 1;
    MS2 = 0;
    MS3 = 0;

    Stepx.write(0.5); // Duty cycle of 50%
    Stepy.write(0.5);

    Enablex = 1;
    Enabley = 1;
    wait(1);
    pc.printf("Start homing");
    wait(2);
    //lcd.cls();
    wait(1);
    Enablex = 0;
    Enabley = 0;
    while(errorx > error_tresh) {

        Ps_x = Posx.read();
        Ps_y = Posy.read();
        errorx = fabs(Pt_x - Ps_x);
        errory = fabs(Ps_y - Pt_y);
       
        if (Ps_x < Pt_x && errorx > error_tresh) {
            Dirx = 0;
            //errorx = Pt_x - Ps_x;
            cx = errorx * H_Gain;

            float hnew_step_freqx;
            hnew_step_freqx = ((1-P_Gain)*setpoint*cx) + (P_Gain*hstep_freqx);
            hstep_freqx = hnew_step_freqx;
            if(hstep_freqx < 2000){
            Stepx.period(1.0/hstep_freqx);
            wait(0.01);}
            else{
            Stepx.period(1.0/setpoint);
            wait(0.01);
            }
            
        }
       
        if (Ps_x > Pt_x && errorx > error_tresh) {
            Dirx = 1;
            //errorx = Pt_x - Ps_x;
            cx = errorx * H_Gain;

            float hnew_step_freqx;
            hnew_step_freqx = ((1-P_Gain)*setpoint*cx) + (P_Gain*hstep_freqx);
            hstep_freqx = hnew_step_freqx;
            if(hstep_freqx < 2000){
            Stepx.period(1.0/hstep_freqx);
            wait(0.01);}
            else{
            Stepx.period(1.0/setpoint);
            wait(0.01);
            }
        }
         pc.printf("%.2f %.2f %.1f %.0f \n", errorx, Ps_x, cx, hstep_freqx);
    }
    pc.printf("Done");
    wait(2);
    Enablex = 1;
    Enabley = 1;
    wait(2);
    pc.printf("Start EMG Control");
    wait(2);
    Enablex = 0;
    Enabley = 0;

    MS1 = 1;
    MS2 = 0;
    MS3 = 0;
    Stepx.write(0.5); // Duty cycle of 50%
    Stepy.write(0.5);

    Ticker emgtimer;    //biceps
    arm_biquad_cascade_df1_init_f32(&lowpass_biceps, 1 , lowpass_const, lowpass_biceps_states);
    arm_biquad_cascade_df1_init_f32(&highnotch_biceps, 2 , highnotch_const, highnotch_biceps_states);
    //triceps
    arm_biquad_cascade_df1_init_f32(&lowpass_triceps, 1 , lowpass_const, lowpass_triceps_states);
    arm_biquad_cascade_df1_init_f32(&highnotch_triceps, 2 , highnotch_const, highnotch_triceps_states);
    //pectoralis major
    arm_biquad_cascade_df1_init_f32(&lowpass_pect, 1 , lowpass_const, lowpass_pect_states);
    arm_biquad_cascade_df1_init_f32(&highnotch_pect, 2 , highnotch_const, highnotch_pect_states);
    //deltoid
    arm_biquad_cascade_df1_init_f32(&lowpass_deltoid, 1 , lowpass_const, lowpass_deltoid_states);
    arm_biquad_cascade_df1_init_f32(&highnotch_deltoid, 2 , highnotch_const, highnotch_deltoid_states);
    emgtimer.attach(looper_emg, 0.01);

    Ticker looptimer1;
    looptimer1.attach(looper_motorx, 0.01); //X-Spindle motor, why this freq?

    //Ticker looptimer2;
    //looptimer2.attach(looper_motory, 0.01); //Y-Spindle motor

    //Microstepping control, now configured as half stepping (MS1=1,MS2=0,MS3=0)



    while (1) {


        pc.printf("%.2f %.2f %.2f  \n", Posx.read(), emg_x, step_freq2); //Send signal values to the computer.
        wait(0.01); 

    }
}
