#include "mbed.h"
#include "HIDScope.h"
#include "arm_math.h"

//Define objects
AnalogIn    emg0(PTB1); //Analog input
HIDScope scope(2);

arm_biquad_casd_df1_inst_f32 lowpass;
//constants for 5Hz lowpass
float lowpass_const[] = {0.5857841106784856, -1.3007020142696517e-16, 0.5857841106784856, -1.3007020142696517e-16, 0.17156822135697122};
//state values
float lowpass_states[4];
arm_biquad_casd_df1_inst_f32 highpass;
//constants for 0.5Hz highpass
float highpass_const[] = {0.8948577513857248, -1.7897155027714495, 0.8948577513857248, 0.8008009266036016};
//state values
float highpass_states[4];


/** Looper function
* functions used for Ticker and Timeout should be of type void <name>(void)
* i.e. no input arguments, no output arguments.
* if you want to change a variable that you use in other places (for example in main)
* you will have to make that variable global in order to be able to reach it both from
* the function called at interrupt time, and in the main function.
* To make a variable global, define it under the includes.
* variables that are changed in the interrupt routine (written to) should be made
* 'volatile' to let the compiler know that those values may change outside the current context.
* i.e.: "volatile uint16_t emg_value;" instead of "uint16_t emg_value"
* in the example below, the variable is not re-used in the main function, and is thus declared
* local in the looper function only.
**/
void looper()
{
    /*variable to store value in*/    
    uint16_t emg_value;
    float filtered_emg;
    float emg_value_f32;
    /*put raw emg value both in red and in emg_value*/
    emg_value = emg0.read_u16(); // read direct ADC result, converted to 16 bit integer (0..2^16 = 0..65536 = 0..3.3V)
    emg_value_f32 = emg0.read();

    //process emg
    arm_biquad_cascade_df1_f32(&highpass, &emg_value_f32, &filtered_emg, 1 );
    filtered_emg = fabs(filtered_emg);
    arm_biquad_cascade_df1_f32(&lowpass, &filtered_emg, &filtered_emg, 1 );
    
    /*send value to PC. */
    scope.set(0,emg_value);     //uint value
    scope.set(1,filtered_emg);  //processed float
    scope.send();

}

int main()
{   
    
    Ticker log_timer;
   //set up filters. Use external array for constants
    arm_biquad_cascade_df1_init_f32(&lowpass,1 , lowpass_const, lowpass_states);
    arm_biquad_cascade_df1_init_f32(&highpass,1 ,highpass_const,highpass_states);

    /**Here you attach the 'void looper(void)' function to the Ticker object
    * The looper() function will be called every 0.01 seconds.
    * Please mind that the parentheses after looper are omitted when using attach.
    */
    log_timer.attach(looper, 0.005);
    while(1) //Loop
    {
      /*Empty!*/
      /*Everything is handled by the interrupt routine now!*/
    }
}