#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

DigitalIn  Switch(SW2);
// Internet of Things clock example: LCD time is set via internet NTP time server
EthernetInterface eth;
NTPClient ntp;

int main() {
    //system time structure
    time_t ctTime;
    
    // lcd.printf prints to LCD display;
    printf("Get IP addr...\r\n");
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address-a is %s\r\n", eth.getIPAddress());
    printf("Reading Time...\r\n");
    //specify time server URL
    TCPSocketConnection sock;
    sock.connect("tock.stdtime.gov.tw", 123);
    //Read time from server
    ntp.setTime("tock.stdtime.gov.tw");
    printf("Time set\n");
    //Delay for human time to read LCD display
    wait(1);
    while (1) {
        if(Switch==0){
            // loop and periodically update the LCD's time display
            ctTime = time(NULL);
            printf("UTC:  %s\r\n", ctime(&ctTime));
            wait(.25);
        }
    }
}
