#include "test.h"
#include "Stoplicht.cpp"
#include "rtos.h"
#include "mbed.h"
#include "Brug.h"
DigitalOut brug(D10);



    Brug::Brug(int Nummer): _thread(&Brug::threadStarter, this, osPriorityNormal,1024){
            mNummer = Nummer;
            mBrugGesloten = false;
            mBrugOpen = false;
            verkeer1 = new Stoplicht(LED1, LED3);
            boot1 = new Stoplicht(LED2, D12);
            _thread.signal_set(0x1);  
        }
            
    void Brug::brug_Ophalen(){
            verkeer1->set_Rood();
            mBrugGesloten = false;
            mBrugOpen = true;
        }
        
    void Brug::brug_LatenZakken(){
            verkeer1->set_Groen(); 
            mBrugOpen = false;
            mBrugGesloten = true; 
        }
        
    bool Brug::check_BrugLeeg(){
            //kijk of brug leeg is 
            return true;   
        }
        
    bool Brug::check_WaterLeeg(){
            //kijk of water leeg is    
            return true;
        }
        
    bool Brug::get_Gesloten(){
            return mBrugGesloten;    
        }
        
    void Brug::set_Gesloten(bool gesloten){
            mBrugGesloten = gesloten;  
        }
        
    bool Brug::get_Open(){
            return mBrugOpen;    
        }
    void Brug::set_Open(bool open){
            mBrugOpen = open;  
        }
        
    void Brug::threadStarter(void const *p){
        Brug *instance = (Brug*)p;
        instance->threadWorker();
    }
    void Brug::threadWorker() {
        _thread.signal_wait(0x1);
        while(1) {

            osEvent evt = brugqueue.get();
            if (evt.status == osEventMessage) {
                if(evt.value.v == 1){
                    brug_LatenZakken();
                }
                else if(evt.value.v == 2){
                    brug_Ophalen();
                }
            }
        }
}
