#include "test.h"
#include "mbed.h"
#include "rtos.h"
#include "Stoplicht.h"
#include "Slagboom.h"
#include "Brug.h"
#include "Noodstop.h"
#include <string>


Queue<uint32_t, 10> brugqueue;
Queue<uint32_t, 10> slagboomqueue;
bool GLOBAL_gesloten;
string State = "init";
Brug *bridge;
Noodstop *emergency;

InterruptIn int_ophalen(D0);
InterruptIn int_latenzakken(D1);
InterruptIn int_vrijmaken(D2);
InterruptIn int_vrijgeven(D3);
InterruptIn int_noodstop(D12);

void latenzakken(){
    brugqueue.put((uint32_t*)BRUG_LATENZAKKEN);
    wait(0.3); //denderen opvangen
}

void ophalen(){
    brugqueue.put((uint32_t*)BRUG_OPHALEN);
    wait(0.3); //denderen opvangen
}

void vrijmaken(){
    slagboomqueue.put((uint32_t*)BRUG_VRIJMAKEN);
    wait(0.3); //denderen opvangen
}

void vrijgeven(){
    slagboomqueue.put((uint32_t*)BRUG_VRIJGEVEN);
    wait(0.3); //denderen opvangen
}

void noodstop(){
    emergency->set_Noodstop();
    wait(0.3); //denderen opvangen
}

int main() {
    pc.baud(230400);
    pc.printf("Init...!\n\r");
    Brug brug1(10);
    bridge = &brug1;
    Noodstop emerg(&brug1);
    emergency = &emerg;
  
    int_ophalen.rise(&ophalen);
    int_latenzakken.rise(&latenzakken);
    int_vrijmaken.rise(&vrijmaken);
    int_vrijgeven.rise(&vrijgeven);
    int_noodstop.rise(&noodstop);

    pc.printf("Interrupt ingesteld!\n\r");
    while(1){}   
}