#include "Slagboom.h"

Slagboom::Slagboom(bool geopend, PinName ophalen, PinName sluiten): _thread2(&Slagboom::threadStarter, this, osPriorityNormal,1024){
    mBoom_Open = geopend;
    mBoom_Gesloten = !mBoom_Open; //Initiele status wordt meegegeven in de constructor
    mOphalen = new DigitalOut(ophalen);
    mSluiten = new DigitalOut(sluiten);
    *mOphalen = false; //Standaard niets doen
    *mSluiten = false;
    verkeer1 = new Stoplicht(D14, D15);
    _thread2.signal_set(0x1);
}
void Slagboom::stoplichtRood(){
    verkeer1->set_Rood();
}

void Slagboom::boom_Ophalen(bool nood) { //Functie om boom op te halen
    pc.printf("BOOM OPHALEN\n\r");
    *mOphalen = true;
    *mSluiten = false;
    mBoom_Gesloten = false;
    float temp = 0;
    for(float i=0;i<5;i+=0.2){
        if(State == "noodstop" && nood == true){
            break;    
        }
        wait(0.2);
        temp += 0.2;
    }
    *mOphalen = false;
    if(temp >= 4.9){
        mBoom_Open = true;
        pc.printf("BOOM OPGEHAALD\n\r");
    }
}

void Slagboom::boom_LatenZakken(bool nood){ //Functie om boom te laten zakken
pc.printf("BOOM ZAKKEN\n\r");
    *mOphalen = false;
    *mSluiten = true;
    mBoom_Open = false;
    float temp = 0;
    for(float i=0;i<5;i+=0.2){
        if(State == "noodstop" && nood == true){
            break;    
        }
        wait(0.2);
        temp += 0.2;
    }
    *mSluiten = false;
    if(temp >= 4.9){
        mBoom_Gesloten = true;
        pc.printf("BOOM GEZAKT\n\r");
    }
}

bool Slagboom::getStatus(){ //Geeft waarde true (of false?) als de boom gesloten is
 return mBoom_Gesloten;

} 

void Slagboom::stoplichtGroen(){
    verkeer1->set_Groen();
}

void Slagboom::setGesloten(){
    mBoom_Gesloten = true;
    mBoom_Open = false;    
}
void Slagboom::setOpen(){
    mBoom_Gesloten = false;
    mBoom_Open = true;    
}

void Slagboom::threadStarter(void const *p)
{
    Slagboom *instance = (Slagboom*)p;
    instance->threadWorker();
}
void Slagboom::threadWorker()
{
    _thread2.signal_wait(0x1);
    while(1) {

        osEvent evt = slagboomqueue.get();
        if (evt.status == osEventMessage) {
            if(evt.value.v == BRUG_VRIJMAKEN) {
                pc.printf("COMMAND: Brug Vrijmaken\n\r");
                if(mBoom_Open == true && State != "noodstop"){
                    verkeer1->set_Rood();
                    wait(1);
                    if(State != "noodstop"){
                        boom_LatenZakken(true);
                    }  
                }
                else{
                    pc.printf("ERROR: Slagbomen zijn al naar beneden!\n\r");
                }
            }
        
            if(evt.value.v == BRUG_VRIJGEVEN) {
                pc.printf("COMMAND: Brug Vrijgeven\n\r");
                string temp = State;
                State = "vrijgeven";
                if(GLOBAL_gesloten == true ){
                    if(mBoom_Gesloten == true ){
                        boom_Ophalen(true);
                        if(State != "noodstop"){
                            wait(1);  
                            verkeer1->set_Groen();
                            pc.printf("MESSAGE: Brug vrij!\n\r");
                        }
                    }
                    else{
                        pc.printf("MESSAGE: Bomen al open!\n\r");     
                    }
                }
                else{
                    pc.printf("ERROR: Brug is nog open!\n\r");    
                }
                State = temp;    
            }
        }  
    }
}
