#include "Brug.h"

DigitalOut bruglatenzakken(D4);
DigitalOut brugophalen(D5);

DigitalIn brugbeneden(D6);
DigitalIn brugboven(D7);
DigitalIn checkwater(D8);
DigitalIn checkbrug(D9);

Brug::Brug(int Nummer): _thread(&Brug::threadStarter, this, osPriorityNormal,1024)
{
    mNummer = Nummer;
    mBrugGesloten = false;
    mBrugOpen = false;
    boot1 = new Stoplicht(LED1, LED3);
//            boot2 = new Stoplicht(LED2, D13);
    slagboom1 = new Slagboom(false, D10, D11);
//            slagboom2 = new Slagboom(true, D9, D8, D7);
    _thread.signal_set(0x1);
    
    if(brugbeneden == true){
        State = "dicht";
        pc.printf("BEGINSTATE: dicht\n\r");
        GLOBAL_gesloten = true;
        boot1->set_Groen();
        slagboom1->stoplichtGroen();
        slagboom1->setOpen();
        set_Gesloten(true);
        set_Open(false);
    }
    else if(brugboven == true){
        State = "open";
        pc.printf("BEGINSTATE: open\n\r");
        GLOBAL_gesloten = false;
        boot1->set_Rood();
        slagboom1->stoplichtRood();
        slagboom1->setGesloten();
        set_Gesloten(false);
        set_Open(true);
    }
    else {
        State = "dicht";
        pc.printf("BEGINSTATE: dicht\n\r");
        GLOBAL_gesloten = true;
        boot1->set_Groen();
        slagboom1->stoplichtGroen();
        slagboom1->setOpen();
        set_Gesloten(true);
        set_Open(false);
    }
}

void Brug::brug_Ophalen()
{
    State = "opengaand";
    pc.printf("STATE: opengaand\n\r");
    brugophalen = true;
    mBrugGesloten = false;
    GLOBAL_gesloten = false;
    
    while(brugboven == false && State != "noodstop"){}

    brugophalen = false;
    if(brugboven == true){
        State = "open";
        pc.printf("STATE: Open\n\r");
        boot1->set_Groen();
        mBrugOpen = true;
    }
    else if(State == "noodstop"){
        pc.printf("MESSAGE: Brug Gestopt!\n\r");
        _thread.signal_set(0x2);
    }
    else{
        pc.printf("Onbekende fout, brug niet open!\n\r");
    }
}

void Brug::brug_LatenZakken()
{
    State = "dichtgaand";
    pc.printf("State: Dichtgaand\n\r");
    bruglatenzakken = true;
    mBrugOpen = false;
    
    while(brugbeneden == false && State != "noodstop"){}
    
    bruglatenzakken = false;
    if(brugbeneden == true){
        State = "dicht";
        pc.printf("State: Dicht\n\r");
        mBrugGesloten = true;
        GLOBAL_gesloten = true;
    }
    else if(State == "noodstop"){
        pc.printf("MESSAGE: Brug Gestopt!\n\r");
        _thread.signal_set(0x2);
    }
    else{
        pc.printf("Onbekende fout, brug niet dicht!\n\r");
    }
}

bool Brug::check_BrugLeeg()
{
    //kijk of brug leeg is
    return checkbrug;
}

bool Brug::check_WaterLeeg()
{
    //kijk of water leeg is
    return checkwater;
}

void Brug::noodstop(){
    brugqueue.put((uint32_t*)NOODSTOP);
}

bool Brug::get_Gesloten()
{
    return mBrugGesloten;
}

void Brug::set_Gesloten(bool gesloten)
{
    mBrugGesloten = gesloten;
}

bool Brug::get_Open()
{
    return mBrugOpen;
}

int Brug::getNummer(){
    return mNummer;     
}

void Brug::set_Open(bool open)
{
    mBrugOpen = open;
}

void Brug::threadStarter(void const *p)
{
    Brug *instance = (Brug*)p;
    instance->threadWorker();
}
void Brug::threadWorker()
{
    _thread.signal_wait(0x1);
    while(1) {
        osEvent evt = brugqueue.get();
        if (evt.status == osEventMessage) {

            /** Brug laten zakken **/
            if(evt.value.v == BRUG_LATENZAKKEN) {
                pc.printf("COMMANDO: brug laten zakken\n\r");
                if(State != "dicht") {
                    
                    boot1->set_Rood();
                    pc.printf("Stoplicht rood!\n\r");
                    wait(1);
                    State = "check_waterbezetting";
                    
                    pc.printf("STATE: Check_waterbezetting: ");
                    if(check_WaterLeeg() == false) {
                        pc.printf("Water leeg!\n\r");
                        brug_LatenZakken();
                    } 
                    else {
                        pc.printf("ERROR: Water niet leeg, probeer nog eens!\n\r");
                    }
                } 
                else {
                    pc.printf("Brug is al dicht!\n\r");
                }
            }

            /** Brug ophalen **/
            else if(evt.value.v == BRUG_OPHALEN) {
                pc.printf("COMMANDO: brug ophalen\n\r");
                //Kijk of brug al open is
                if( State != "open" ) {
                    
                    //Kijk of slagbomen dicht zijn
                    State = "slagboomcheck";
                    pc.printf("STATE: slagboomcheck\n\r");
                    if ( slagboom1->getStatus() == false) {
                        State = "dicht";
                        pc.printf("STATE: Dicht\n\r");
                        pc.printf("ERROR: Er staat nog een slagboom open\n\r");
                    }
                    else{
                        State = "brugcheck";
                        pc.printf("STATE: Brugcheck\n\r");
                    }
                    
                    //Kijk of er niks meer op de brug is
                    if(State == "brugcheck"){
                        
                        if(check_BrugLeeg() == false) {
                            brug_Ophalen();
                        }
                        else{
                            State = "dicht";
                            pc.printf("STATE: Dicht\n\r");
                            pc.printf("ERROR: Brug niet leeg!\n\r");
                        }
                    }
                }
                else {
                    pc.printf("ERROR: Brug is al open!");
                }     
            }
            
            else if(evt.value.v == NOODSTOP) {
                 pc.printf("STATE: Noodstop\n\r");
                boot1->set_Rood();
                slagboom1->stoplichtRood();
                if(slagboom1->getStatus() == false){
                    slagboom1->boom_LatenZakken(false);
                }
                if(mBrugGesloten == false && mBrugOpen == false && (bruglatenzakken == 1 || brugophalen == 1)){
                    _thread.signal_wait(0x2);
                }
                pc.printf("STATE: Noodstop geslaagd!\n\r");
            }
        }
    }
}
