#include "mbed.h"
#include "xIFO.h"

DigitalOut myled(LED1);

// Create a buffer (note that this is a C module, not an object)
xifo_t buffer;
// Allocate memory for buffer
xifo_pool_t buffer_memory[16]; 

int main() {
    uint32_t data, succes;

    // Initialise the created buffer
    xifo_init(&buffer, 128, (uint32_t *)&buffer_memory); 
    
    // Erase buffer contents
    xifo_clear(&buffer);

    // Write some data
    succes = xifo_write(&buffer, 0x1); 
    succes = xifo_write(&buffer, 0x2); 
    succes = xifo_write(&buffer, 0x3);
    succes = xifo_write(&buffer, 0x4); 
    succes = xifo_write(&buffer, 0x5); 
    // Are we full yet?
    if( xifo_get_free(&buffer) > 0 )
    {
        succes = xifo_write(&buffer, 0x6); 
    }
            
    /* Read from the buffer, read-only! */
    // Read the least recent element        : 0x1
    data = xifo_read_lr(&buffer, 0);  
    
    // Read the 2nd least recent element    : 0x2
    data = xifo_read_lr(&buffer, 1);
    
    // Read the most recent element         : 0x6
    data = xifo_read_mr(&buffer, 0);
    
    // Read the 2nd most recent element     : 0x5
    data = xifo_read_mr(&buffer, 1);
    
    /* Pop from the buffer, removes elements */
    // Remove the least recent element      : 0x1
    data = xifo_pop_lr(&buffer);
    
    // Remove the most recent element       : 0x6
    data = xifo_pop_mr(&buffer);
    
    /* Done 
     * Buffer should have this: 0x2, 0x3, 0x4, 0x5
     */
        
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
