#include "mbed.h"
#include "USBHostSerial.h"

DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial pc(USBTX, USBRX);
int chronos_answer[10] ;

void serial_task(void const*)
{
    USBHostSerial serial;


    while(!serial.connect())
        Thread::wait(500);

    serial.baud(115200) ;

    pc.printf("chronos init ...\n") ;

    serial.putc(0xff) ;
    serial.putc(0x07) ;
    serial.putc(0x03) ;
    pc.printf("chronos init completed ...\n") ;


    while(1) {

        // send read request to chronos
        serial.putc(0xFF);
        serial.putc(0x08);
        serial.putc(0x07);
        serial.putc(0x00);
        serial.putc(0x00);
        serial.putc(0x00);
        serial.putc(0x00);
        Thread::wait(15);


        // put received characters on an array
        int i = 0 ;
        while (serial.available()) {
            int c_in = serial.getc() ;
            chronos_answer[i++] = c_in ;
        }
        int button = chronos_answer[3] ;
        if(button != 255) {
            printf("Button received : %d\n", button ) ;
            switch(button) {
                case 18 :       // * button
                    led2 = 1 ;
                    led3 = 0 ;
                    led4 = 0 ;
                    break ;
                case 50 :       // up button
                    led2 = 0 ;
                    led3 = 1 ;
                    led4 = 0 ;
                    break ;
                case 34 :       // # button
                    led2 = 0 ;
                    led3 = 0 ;
                    led4 = 1 ;
                    break ;

            }
        }


        Thread::wait(50);

    }
}

int main()
{
    Thread serialTask(serial_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}