/******************************************************************************
 *
 *    FILENAME:    APSDS_9300.h
 *    DATE:        2012
 *    AUTHOR:      Jeremy CEVRERO
 *
 *    DESCRIPTION: Driver for APDS_9300 Ambiant light sensor (Avago)
 *
 ******************************************************************************/

I2C i2c(p28, p27);// sda, scl       ; 

/** Declaration des variables  *****************************************************************/
char ch0H;//variable ADC0 octet fort
char ch0L;//variable ACDC0 octet faible
int ch0;//valeur de chO sur 16 bits
char ch1H;//variable ADC1 octet fort
char ch1L;//variable ADC1 octet faible
int ch1;//valeur de ch1 sur 16 bits
float ch1divch0;//ch1/ch0
float luminosite;// luminosite en lux
int adresse = 0x52;//adresse du APDS-9300 ( pour adr sel a la masse)
float a;//niveau de luminosite


/*******************************************************************************
 * FUNCTION:   start_9300
 * PURPOSE:    Dmarrer le composant.
 ******************************************************************************/
void start_9300 ()
        { 
        char cmd[2];               
        cmd[0] = 0x80;//registre de commande selectionne le registre de controle
        cmd[1] = 0x03;//Registre de controle met en route le composant
        i2c.write(adresse, cmd, 2);
        wait(0.1);
        }
        
/*******************************************************************************
 * FUNCTION:   stop_9300
 * PURPOSE:    Stopper le composant.
 ******************************************************************************/
void stop_9300 ()

        { 
        char cmd[2];
        cmd[0] = 0x80;//registre de commande selectionne le registre de controle
        cmd[1] = 0x12;//Registre de controle stoppe le composant
        i2c.write(adresse, cmd, 2);
        wait(0.1);
        }

/*******************************************************************************
 * FUNCTION:   read_9300
 * PURPOSE:    Lire la luminosite et l'afficher sur l'hyperterminal.
 ******************************************************************************/        
void read_9300 ()
        {
        
        start_9300 ();//Allume le composant       
          
        char cmd[2];               
        cmd[0] = 0x81;//s&#65533;lectionne le timing register
        cmd[1] = 0x02;//mode low gain temps d'int&#65533;gration = 402ms         
        i2c.write(adresse, cmd, 2);

         cmd[0] = 0x8C;  //lecture datalow canal 0           
        i2c.write(adresse,cmd, 1);
        i2c.read(adresse|1,&ch0L,1,0);
       
        cmd[0] = 0x8D;  //lecture datahigh canal 0           
        i2c.write(adresse,cmd, 1);
        i2c.read(adresse|1,&ch0H,1,0);
        ch0=(ch0H <<8) + ch0L;
         
        cmd[0] = 0x8E;  //lecture datalow canal 1        
        i2c.write(adresse,cmd, 1);
        i2c.read(adresse|1,&ch1L,1,0);
      
        cmd[0] = 0x8F;  //lecture datahigh canal 1           
        i2c.write(adresse,cmd, 1);
        i2c.read(adresse|1,&ch1H,1,0);
        ch1=(ch1H <<8) + ch1L;

        ch1divch0 = ch1*1.0f / ch0;//ch1divch0=ch1/ch0 flottant 
        
        if (0 <= ch1divch0 <= 0.52)//si ch1/ch0 compris entre 0 et 0.52 alors on applique la formule suivant
            {
            luminosite = (0.0315 * ch0) -((0.0593 * ch0) * (powf((ch1/ch0),1.4)));
            }
            else if (0.52 <= ch1divch0 <= 0.65)//sinon si il est compris entre 0.52 et 0.65
                {
                luminosite = ((0.0229 * ch0) - (0.0291 * ch1));//on applique cette formule
                }
                else if (0.65 <= ch1divch0 <= 0.80)//sinon si il est compris entre 0.65 et 0.80
                    {
                    luminosite = (0.0157 * ch0) - (0.0180 * ch1);//on applique cette formule
                    }
                    else if (0.80 <= ch1divch0<= 1.30)//sinon si il est compris entre 0.8 et 1.3
                        {
                        luminosite = (0.00338 * ch0) - (0.00260 * ch1);//on applique cette formule
                        }
                        else if (ch1divch0 >= 1.30)//sinon
                            {
                            luminosite = 0;
                            }
        luminosite=luminosite*16;
        
         pc.printf("ch1divch0 = %f, ch1 = Ox%X ,ch0 = 0x%X,luminosite = %f \n\r",ch1divch0,ch1, ch0,luminosite);// affiche ch1/ch0,ch1,ch0et luminosite
         a = luminosite/100000;//Generation du pwm
              stop_9300 ();//Eteint le composant   

}
