// Simple Cat Food Dispenser
// Jeremy Xiaoyi Cai

#include "mbed.h"
#include "Servo.h"
#include "SDFileSystem.h"
#include "wave_player.h"

// SD card
SDFileSystem sd(p5, p6, p7, p8, "sd");
// Waveplayer
AnalogOut DACout(p18);
wave_player waver(&DACout);
// Bluetooth
Serial blue(p28,p27);
// Servo
Servo myservo(p21);

int main()
{
   // Adjust servo to default position
   myservo = 0.0;

    while(1) {
        // Check whether user is sending "feed" through bluetooth
        if (blue.getc()=='f') {
            if (blue.getc()=='e') {
                if (blue.getc()=='e') {
                    if (blue.getc()=='d') {
                        // After receiving "feed", start dispensing cat food
                        myservo = 0.7;
                        wait(1);
                        myservo = 0.0;
                        wait(0.5);
                        
                        // Play wav file on SD
                        FILE *wave_file;
                        wave_file=fopen("/sd/food.wav","r");
                        waver.play(wave_file);
                        fclose(wave_file);

                    }
                }
            }
        }
    }
}