#include <stdlib.h>

#include "mbed.h"
//#include "LCD_DISCO_F469NI.h"
#include "USBHostMSD.h"
#include "FATFileSystem.h"

//LCD_DISCO_F469NI lcd;

DigitalOut led_green(LED1);
DigitalOut led_orange(LED2);
DigitalOut led_red(LED3);
DigitalOut led_blue(LED4);

Serial pc(SERIAL_TX, SERIAL_RX);

void msd_task(void const *) {

    USBHostMSD msd;
    int i = 0;
    FATFileSystem fs("usb");
    int err;
    printf("wait for usb memory stick insertion\n");
    while(1) {

        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(500);
        }
        if (fs.mount(&msd) != 0) continue;
        else
            printf("file system mounted\n");

        if  (!msd.connect()) {
            continue;
        }

        // in a loop, append a file
        // if the device is disconnected, we try to connect it again

        // append a file
        File file;
        err = file.open(&fs, "test1.txt", O_WRONLY | O_CREAT |O_APPEND);

        if (err == 0) {
            char tmp[100];
            sprintf(tmp,"Hello fun USB stick  World: %d!\r\n", i++);
            file.write(tmp,strlen(tmp));
            sprintf(tmp,"Goodbye World!\r\n");
            file.write(tmp,strlen(tmp));
            file.close();
        } else {
            printf("FILE == NULL\r\n");
        }
        Thread::wait(500);
        printf("again\n");
        // if device disconnected, try to connect again
        while (msd.connected()) {
            Thread::wait(500);
        }
        while (fs.unmount() < 0) {
            Thread::wait(500);
            printf("unmount\n");
        }
    }
}

int main() {

    pc.baud(115200);

    //lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"MBED EXAMPLE", CENTER_MODE);
    //wait(1);

    Thread msdTask(msd_task, NULL, osPriorityNormal, 1024 * 4);

    //lcd.Clear(LCD_COLOR_BLUE);
    //lcd.SetBackColor(LCD_COLOR_BLUE);
    //lcd.SetTextColor(LCD_COLOR_WHITE);

    //BSP_LCD_SetFont(&Font20);
    //lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"HAVE FUN !!!", CENTER_MODE);

    while(1) {
        // WARNING: LEDs are OFF
        led_green = 1;
        led_orange = 1;
        led_red = 1;
        led_blue = 1;
        wait(0.2); // 200 ms
        // WARNING: LEDs are ON
        led_green = 0;
        led_orange = 0;
        led_red = 0;
        led_blue = 0;
        wait(1.0); // 1 sec
    }
}
