#include "net_sockets.h"
#include "network_interface.h"
//#include "EthernetInterface.h"
#include "TCPSocket.h"
#include "ESP8266Interface.h"

TCPSocket * tcp_socket;

void mbedtls_net_init(mbedtls_net_context *ctx) {
	//EthernetInterface eth_iface;
	ESP8266Interface eth_iface(D1, D0);
	//eth_iface.connect();
	eth_iface.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
	tcp_socket = new TCPSocket(&eth_iface);
	return;
}

int mbedtls_net_connect(mbedtls_net_context *ctx, const char *host,
		const char *port, int proto) {
	    return tcp_socket->connect(host, atoi(port));
}

int mbedtls_net_set_block(mbedtls_net_context *ctx) {
	tcp_socket->set_blocking(false);
	return 0;
}

int mbedtls_net_recv(void *ctx, unsigned char *buf, size_t len) {
	return tcp_socket->recv(buf, len);
}

int mbedtls_net_send(void *ctx, const unsigned char *buf, size_t len) {
	int size = -1;

	    size = tcp_socket->send(buf, len);

	    if(NSAPI_ERROR_WOULD_BLOCK == size){
	        return len;
	    }else if(size < 0){
	        return -1;
	    }else{
	        return size;
	    }
}

int mbedtls_net_recv_timeout(void *ctx, unsigned char *buf, size_t len,
		uint32_t timeout) {

	    int recv = -1;
	    tcp_socket->set_timeout(timeout);
	    recv = tcp_socket->recv(buf, len);

	    if(NSAPI_ERROR_WOULD_BLOCK == recv ||
	       recv == 0){
	        return 0;
	    }else if(recv < 0){
	        return -1;
	    }else{
	        return recv;
	    }
}

void mbedtls_net_free(mbedtls_net_context *ctx) {
	return;
}
