/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

/**
 * @file aws_iot_config.h
 * @brief AWS IoT specific configuration file
 */

#ifndef SRC_SHADOW_IOT_SHADOW_CONFIG_H_
#define SRC_SHADOW_IOT_SHADOW_CONFIG_H_


static char AWS_IOT_ROOT_CA [] = \
"-----BEGIN CERTIFICATE-----\n"\
"MIIE0zCCA7ugAwIBAgIQGNrRniZ96LtKIVjNzGs7SjANBgkqhkiG9w0BAQUFADCB\n"\
"yjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL\n"\
"ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp\n"\
"U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW\n"\
"ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0\n"\
"aG9yaXR5IC0gRzUwHhcNMDYxMTA4MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCByjEL\n"\
"MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZW\n"\
"ZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJpU2ln\n"\
"biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJp\n"\
"U2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9y\n"\
"aXR5IC0gRzUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvJAgIKXo1\n"\
"nmAMqudLO07cfLw8RRy7K+D+KQL5VwijZIUVJ/XxrcgxiV0i6CqqpkKzj/i5Vbex\n"\
"t0uz/o9+B1fs70PbZmIVYc9gDaTY3vjgw2IIPVQT60nKWVSFJuUrjxuf6/WhkcIz\n"\
"SdhDY2pSS9KP6HBRTdGJaXvHcPaz3BJ023tdS1bTlr8Vd6Gw9KIl8q8ckmcY5fQG\n"\
"BO+QueQA5N06tRn/Arr0PO7gi+s3i+z016zy9vA9r911kTMZHRxAy3QkGSGT2RT+\n"\
"rCpSx4/VBEnkjWNHiDxpg8v+R70rfk/Fla4OndTRQ8Bnc+MUCH7lP59zuDMKz10/\n"\
"NIeWiu5T6CUVAgMBAAGjgbIwga8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8E\n"\
"BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJaW1hZ2UvZ2lmMCEwHzAH\n"\
"BgUrDgMCGgQUj+XTGoasjY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy\n"\
"aXNpZ24uY29tL3ZzbG9nby5naWYwHQYDVR0OBBYEFH/TZafC3ey78DAJ80M5+gKv\n"\
"MzEzMA0GCSqGSIb3DQEBBQUAA4IBAQCTJEowX2LP2BqYLz3q3JktvXf2pXkiOOzE\n"\
"p6B4Eq1iDkVwZMXnl2YtmAl+X6/WzChl8gGqCBpH3vn5fJJaCGkgDdk+bW48DW7Y\n"\
"5gaRQBi5+MHt39tBquCWIMnNZBU4gcmU7qKEKQsTb47bDN0lAtukixlE0kF6BWlK\n"\
"WE9gyn6CagsCqiUXObXbf+eEZSqVir2G3l6BFoMtEMze/aiCKm0oHw0LxOXnGiYZ\n"\
"4fQRbxC1lfznQgUy286dUV4otp6F01vvpX1FQHKOtw5rDgb7MzVIcbidJ4vEZV8N\n"\
"hnacRHr2lVz2XTIIM6RUthg/aFzyQkqFOFSDX9HoLPKsEdao7WNq\n"\
"-----END CERTIFICATE-----\0";

static char AWS_IOT_CERTIFICATE [] = \
"-----BEGIN CERTIFICATE-----\n"\
"MIIDWTCCAkGgAwIBAgIUTOhiAJm6t9F8cHGiiTF8/bsRqa4wDQYJKoZIhvcNAQEL\n"\
"BQAwTTFLMEkGA1UECwxCQW1hem9uIFdlYiBTZXJ2aWNlcyBPPUFtYXpvbi5jb20g\n"\
"SW5jLiBMPVNlYXR0bGUgU1Q9V2FzaGluZ3RvbiBDPVVTMB4XDTE3MDQwNTE2NDA0\n"\
"MVoXDTQ5MTIzMTIzNTk1OVowHjEcMBoGA1UEAwwTQVdTIElvVCBDZXJ0aWZpY2F0\n"\
"ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKCMT3ozETT/YqRDk2iQ\n"\
"aZUgbkBVNweaKPWTbHsvItxVrBdsqUAGrTsYGX34OXgBiGamwO8FO3CDwDtnIxhm\n"\
"VGA2gJc33O6xHscPeP4LNi1F6L2NjPeMy2d4RZTUhYJbliL2JZ3nxrTod8WzBGxZ\n"\
"a75tZkt4DUSH+ON0f1DUQYTp6p1h9L3s21n9Yf8tq4Wxs1AE15pToRB181HPK4Is\n"\
"UYIdJ3E+bdTKA3K7uwiX1sM6puMDOkQeT4qE4s+wNIdzhfANa7UmPN4EL1H/gobz\n"\
"FlgiujG6VjyydLhTVVBxLH1f6bEC2pOO8mcS1vlu+IKWozbM65lR4oBMXRCU2bZI\n"\
"WhkCAwEAAaNgMF4wHwYDVR0jBBgwFoAU8WlgRVSkcjjMbpU8Psg8CBIkXAEwHQYD\n"\
"VR0OBBYEFA/Hn7qjU+K7F5T3DpYyocz/hkZvMAwGA1UdEwEB/wQCMAAwDgYDVR0P\n"\
"AQH/BAQDAgeAMA0GCSqGSIb3DQEBCwUAA4IBAQAuAPD7l2PRwhQW8KsG/14C+P2t\n"\
"gadtDlDFkHKZFXkS/fjYd9avijJWktboVSLQXqmJj2e88gDT6mrK6UjXoJH/S0MP\n"\
"HzhQ1c1pMjFYlRlGDJR+FJbSPMRWKbE/l/f5+XdkH13o4o3MD2E4jIWW33G8fhB6\n"\
"53fGFXfuj+8O7w0JBH0vZvWz3G6KQzG69j597vkyKzthc58fYhLOvMCklO2D9h+C\n"\
"IWnHDivkqboXI6lACUueuDlH2UJcQBACZlVJ14F5cZwbosJo2D/nSk8VvPcMwoT1\n"\
"T3ut2VYu1LmRwFxPHhP7c0RhvgE16j03dfPyDkm0eMQEo99RJrbAnVJK1mrd\n"\
"-----END CERTIFICATE-----\0";

static char AWS_IOT_PRIVATE_KEY [] = \
"-----BEGIN RSA PRIVATE KEY-----\n"\
"MIIEowIBAAKCAQEAoIxPejMRNP9ipEOTaJBplSBuQFU3B5oo9ZNsey8i3FWsF2yp\n"\
"QAatOxgZffg5eAGIZqbA7wU7cIPAO2cjGGZUYDaAlzfc7rEexw94/gs2LUXovY2M\n"\
"94zLZ3hFlNSFgluWIvYlnefGtOh3xbMEbFlrvm1mS3gNRIf443R/UNRBhOnqnWH0\n"\
"vezbWf1h/y2rhbGzUATXmlOhEHXzUc8rgixRgh0ncT5t1MoDcru7CJfWwzqm4wM6\n"\
"RB5PioTiz7A0h3OF8A1rtSY83gQvUf+ChvMWWCK6MbpWPLJ0uFNVUHEsfV/psQLa\n"\
"k47yZxLW+W74gpajNszrmVHigExdEJTZtkhaGQIDAQABAoIBACO+eWdsfTU+cri9\n"\
"rtEF7evct48tKb5QjTP3qZxXZzyE+naQo7H0ipbwi6RnImxccwDfuW69zHkFbEQN\n"\
"d1vUVI7DM6f3MQIXfxG0mSx+VIaJ3QJuxGbM+vBDb8Jt+neGaovIH6HjW3Mlmpzy\n"\
"eVaiJgHUm4TL6rBKUZhadIoLZ7bufeikmEYTZyxHBSa/7VpPSroMbbXjWqJDovRe\n"\
"HodSXBi7B8xlBmrx6yZhNBc/fkDtVvriK3ii7jjzxX+GH1tGpIyjMBU16l8/zjTD\n"\
"+QGKzDGexCcamJyb5XlRlXSa+QNGrBu3Es/91V/MYjvGTWU9/dES0bgMvVY2iDQA\n"\
"ECJzZPECgYEA7sax18AEGnQUEPGKdPrwndIh7k2ovXH81JBgkWSdB8PWA6+1RtcU\n"\
"XaFwfx6tQpzNhY+eP9cPqSaRcl3wHmwTChawRP+0lWoplUhft7zNsBX1OX9zm0d0\n"\
"vuNpCRpKWeXilIhUBWwwuKSn00z0D8mWQUdqQUU/dFbCweezfGCubBUCgYEArCEI\n"\
"+v7KyDzPBs590p5ktWQ3GMVXYg4yAZP9MUskzLut0lbmY9r7Yz8RL8y6iBJco7L+\n"\
"ry265G6MWqXvnjbsMrvgD1Bv466Oe7Wvez+zklwFtum0nrlwRhDdndhrHV1MUpKv\n"\
"4Ea1suogcoDNEdI5eSDnajiWoCYi1l1sUbFnwvUCgYB6FCZrG2Y9rClyPDxA8OfC\n"\
"mOP2NchXC4drmmF1FI7goHS0L8qr7F0iPd8Jb0LAMvE1HyeWljsQjYKBiZuxwim9\n"\
"17nJnT7TwZJ/G6CsjSBQrflRq2MM+eyriBN0rvdinRFKRaVHnHgQf0a61rZVuAhV\n"\
"WdDujBwUPCOZBgCTT879vQKBgFxdMbN1y5ydPL47SbseMY5AY2xQYK6GTYEZR1EP\n"\
"MIUH5KMs7F4C4MiFzBQpOKLRr5JL92xLDrGLPJdb2XO9pwsmU3oEQLYdMeniOXLa\n"\
"YOKVrJ9VUw2lFkESxcjwm7HbIZxhiCzB5LhH9/dZdDEu7JY5+NO/39u5+xGqefhw\n"\
"SOyNAoGBAIPf+vNXSFaGZubKHx6O28fjCVJvSsu4xazuIoCSZiayJLDHRgMVOIqq\n"\
"6cWn6hAN4SIo6QAknU86MPsHZRRxuUaY5OtF5ucPMS+txnXwr9d7RIGZirSL01yp\n"\
"T4li1IMCa6uFoO+TFQHYF7ObzIGaTl5rsOSyFdIvmq+VZvvNqxit\n"\
"-----END RSA PRIVATE KEY-----\0";

static char PASSWORD [] = "";

// Get from console
// =================================================
#define AWS_IOT_MQTT_HOST              "aewcj8vppr8nv.iot.us-east-1.amazonaws.com" ///< Customer specific MQTT HOST. The same will be used for Thing Shadow
#define AWS_IOT_MQTT_PORT              8883 ///< default port for MQTT/S
#define AWS_IOT_MQTT_CLIENT_ID         "K64F_CPI" ///< MQTT client ID should be unique for every device
#define AWS_IOT_MY_THING_NAME          "K64F_CPI" ///< Thing Name of the Shadow this device is associated with
#define AWS_IOT_ROOT_CA_FILENAME       "rootCA.crt" ///< Root CA file name
#define AWS_IOT_CERTIFICATE_FILENAME   "aeae2025ec-certificate.pem.crt" ///< device signed certificate file name
#define AWS_IOT_PRIVATE_KEY_FILENAME   "aeae2025ec-private.pem.key" ///< Device private key filename
// =================================================

// MQTT PubSub
#define AWS_IOT_MQTT_TX_BUF_LEN 512 ///< Any time a message is sent out through the MQTT layer. The message is copied into this buffer anytime a publish is done. This will also be used in the case of Thing Shadow
#define AWS_IOT_MQTT_RX_BUF_LEN 512 ///< Any message that comes into the device should be less than this buffer size. If a received message is bigger than this buffer size the message will be dropped.
#define AWS_IOT_MQTT_NUM_SUBSCRIBE_HANDLERS 5 ///< Maximum number of topic filters the MQTT client can handle at any given time. This should be increased appropriately when using Thing Shadow

// Thing Shadow specific configs
#define SHADOW_MAX_SIZE_OF_RX_BUFFER AWS_IOT_MQTT_RX_BUF_LEN+1 ///< Maximum size of the SHADOW buffer to store the received Shadow message
#define MAX_SIZE_OF_UNIQUE_CLIENT_ID_BYTES 80  ///< Maximum size of the Unique Client Id. For More info on the Client Id refer \ref response "Acknowledgments"
#define MAX_SIZE_CLIENT_ID_WITH_SEQUENCE MAX_SIZE_OF_UNIQUE_CLIENT_ID_BYTES + 10 ///< This is size of the extra sequence number that will be appended to the Unique client Id
#define MAX_SIZE_CLIENT_TOKEN_CLIENT_SEQUENCE MAX_SIZE_CLIENT_ID_WITH_SEQUENCE + 20 ///< This is size of the the total clientToken key and value pair in the JSON
#define MAX_ACKS_TO_COMEIN_AT_ANY_GIVEN_TIME 10 ///< At Any given time we will wait for this many responses. This will correlate to the rate at which the shadow actions are requested
#define MAX_THINGNAME_HANDLED_AT_ANY_GIVEN_TIME 10 ///< We could perform shadow action on any thing Name and this is maximum Thing Names we can act on at any given time
#define MAX_JSON_TOKEN_EXPECTED 120 ///< These are the max tokens that is expected to be in the Shadow JSON document. Include the metadata that gets published
#define MAX_SHADOW_TOPIC_LENGTH_WITHOUT_THINGNAME 60 ///< All shadow actions have to be published or subscribed to a topic which is of the format $aws/things/{thingName}/shadow/update/accepted. This refers to the size of the topic without the Thing Name
#define MAX_SIZE_OF_THING_NAME 20 ///< The Thing Name should not be bigger than this value. Modify this if the Thing Name needs to be bigger
#define MAX_SHADOW_TOPIC_LENGTH_BYTES MAX_SHADOW_TOPIC_LENGTH_WITHOUT_THINGNAME + MAX_SIZE_OF_THING_NAME ///< This size includes the length of topic with Thing Name

// Auto Reconnect specific config
#define AWS_IOT_MQTT_MIN_RECONNECT_WAIT_INTERVAL 1000 ///< Minimum time before the First reconnect attempt is made as part of the exponential back-off algorithm
#define AWS_IOT_MQTT_MAX_RECONNECT_WAIT_INTERVAL 128000 ///< Maximum time interval after which exponential back-off will stop attempting to reconnect.

#endif /* SRC_SHADOW_IOT_SHADOW_CONFIG_H_ */
