/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500


int main()
{
    // Initialize the digital pin LED1 as an output
    DigitalOut led(LED1);
    // Initialize the serial UART on the USB Transmit and Receive pins
    Serial pc(USBTX, USBRX);
    // Print a string on the serial port
    pc.printf("Hello World!\n");
    while (true) 
    {
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
