#include "RGBLed.h"

RGBLed::RGBLed(PinName redPin, PinName greenPin, PinName bluePin) : m_red(redPin), m_green(greenPin), m_blue(bluePin)
{
}

void RGBLed::init()
{
    m_red.period(0.001);
}

void RGBLed::setColor(const float red, const float green, const float blue)
{
    // Negative logic
    m_red = 1.f - red;
    m_green = 1.f - green;
    m_blue = 1.f - blue;
}