#include "mbed.h"
#include "PushDuration.h"
/**
 * React() function is called by release() when the button is released. It traverses through the two
 * dimensional key vale array and matches the push duration with the corresponding callback function.
**/
void ButtonHandler::react(int counter) const {
    const action *a = mTable.table;
    for (std::size_t i=mTable.size; i; --i, ++a) {
        if ((counter >= a->counter_limit) && counter < (a+1)->counter_limit ) {
            a->transition();
            return;
        }
    }
}

/**
 * Configures the button pin mode, attaches callback functions for rise and fall
 * and enables IRQ for the given pin. 
**/
void ButtonHandler::enable() {
    buttonPin.mode(PullDown);
    wait(0.01);
    buttonPin.rise(this, &ButtonHandler::release);
    buttonPin.fall(this, &ButtonHandler::press);
    buttonPin.enable_irq();
}


void ButtonHandler::disable() {
    buttonPin.disable_irq();
    ticker.detach();
}

void ButtonHandler::release() {
    counter = 0;
    ticker.attach(this, &ButtonHandler::secondsCount, intervalInSeconds);
}

void ButtonHandler::press() {
    ticker.detach();
    react(counter);
    counter = 0;
}

void ButtonHandler::secondsCount() {
    ++counter;
    printf("counter: %d\n", counter);
}
