/**
 * This program demonstrates the usage of the LedBlink Library.
 * It counts the number of button interrupts (falling edge) and
 * sets the blink frequency to a new value by calling the Blinker
 * function of class LedBlink and passing a float as paramter for
 * the frequency where 0 = off and 1 = 1 hz.

 * Example:
 * @code

 * #include "mbed.h"
 * #include "LedBlink.h"

 * InterruptIn pb(p17);
 * // SPST Pushbutton count demo using interrupts
 * // no external PullUp resistor needed
 * // Pushbutton from P17 to GND.
 * // A pb falling edge (hit) generates an interrupt and activates the interrupt routine

 * // Global count variable
 * int volatile count=0;

 * //Instantiate LedBlink object.
 * LedBlink ledb(p21);

 * // pb Interrupt routine - is interrupt activated by a falling edge of pb input
 * void pb_hit_interrupt (void) {
 *    count++;
 * //Set Blink Frequency based on button count.
 * //Function Blinker accepts a parameter of type float to set the blink frequency.
 *   if (count == 1){
 *       ledb.Blinker(1.0);
 *       }
 *   if (count == 2){
 *       ledb.Blinker(0.5);
 *       }
 *   if (count == 3){
 *       ledb.Blinker(0.1);
 *       }
 *   if (count == 4){
 *       ledb.Blinker(0);
 *       count = 0;
 *       }
 *   }

 *int main(void) {
 *   // Use internal pullup for pushbutton
 *   pb.mode(PullUp);
 *   // Delay for initial pullup to take effect
 *   wait(.01);
 *   // Attach the address of the interrupt handler routine for pushbutton
 *   pb.fall(&pb_hit_interrupt);

 *   while (1){
 *   }
 *}
 *@endcode
 */
#ifndef MBED_LEDBLINK_H
#define MBED_LEDBLINK_H

#include "mbed.h"

class LedBlink
{
public:
    /** Create a LedBlink object
     * @param frequency
     * @param led
     */
    LedBlink(PinName pin);
    void Blinker(float frequency);

private:

    DigitalOut _pin;



    /** Internal ticker to set LED blink frequency
     *
     */
    void LedBlinkCallback(void);

};
#endif